"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def preview(
    hub, ctx, preview_agents_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Previews the agents installed on the EC2 instances that are part of the specified assessment target.

    Args:
        preview_agents_arn(str): The ARN of the assessment target whose agents you want to preview.
        next_token(str, optional): You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the PreviewAgents action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data. Defaults to None.
        max_results(int, optional): You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.inspector.agent.preview(ctx, preview_agents_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.inspector.agent.preview preview_agents_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="inspector",
        operation="preview_agents",
        op_kwargs={
            "previewAgentsArn": preview_agents_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
