"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, job_id: str, api_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job. You can only return information about jobs you own.

    Args:
        job_id(str): A unique identifier which refers to a particular job.
        api_version(str, optional): Specifies the version of the client tool. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.importexport.status.get(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.importexport.status.get job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="importexport",
        operation="get_status",
        op_kwargs={"JobId": job_id, "APIVersion": api_version},
    )
