"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    job_ids: List,
    name: str = None,
    company: str = None,
    phone_number: str = None,
    country: str = None,
    state_or_province: str = None,
    city: str = None,
    postal_code: str = None,
    street1: str = None,
    street2: str = None,
    street3: str = None,
    api_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation generates a pre-paid UPS shipping label that you will use to ship your device to AWS for processing.

    Args:
        job_ids(List): .
        name(str, optional): Specifies the name of the person responsible for shipping this package. Defaults to None.
        company(str, optional): Specifies the name of the company that will ship this package. Defaults to None.
        phone_number(str, optional): Specifies the phone number of the person responsible for shipping this package. Defaults to None.
        country(str, optional): Specifies the name of your country for the return address. Defaults to None.
        state_or_province(str, optional): Specifies the name of your state or your province for the return address. Defaults to None.
        city(str, optional): Specifies the name of your city for the return address. Defaults to None.
        postal_code(str, optional): Specifies the postal code for the return address. Defaults to None.
        street1(str, optional): Specifies the first part of the street address for the return address, for example 1234 Main Street. Defaults to None.
        street2(str, optional): Specifies the optional second part of the street address for the return address, for example Suite 100. Defaults to None.
        street3(str, optional): Specifies the optional third part of the street address for the return address, for example c/o Jane Doe. Defaults to None.
        api_version(str, optional): Specifies the version of the client tool. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.importexport.shipping_label.get(ctx, job_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.importexport.shipping_label.get job_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="importexport",
        operation="get_shipping_label",
        op_kwargs={
            "jobIds": job_ids,
            "name": name,
            "company": company,
            "phoneNumber": phone_number,
            "country": country,
            "stateOrProvince": state_or_province,
            "city": city,
            "postalCode": postal_code,
            "street1": street1,
            "street2": street2,
            "street3": street3,
            "APIVersion": api_version,
        },
    )
