"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, max_jobs: int = None, marker: str = None, api_version: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns the jobs associated with the requester. AWS Import/Export lists the jobs in reverse chronological order based on the date of creation. For example if Job Test1 was created 2009Dec30 and Test2 was created 2010Feb05, the ListJobs operation would return Test2 followed by Test1.

    Args:
        max_jobs(int, optional): Sets the maximum number of jobs returned in the response. If there are additional jobs that were not returned because MaxJobs was exceeded, the response contains <IsTruncated>true</IsTruncated>. To return the additional jobs, see Marker. Defaults to None.
        marker(str, optional): Specifies the JOBID to start after when listing the jobs created with your account. AWS Import/Export lists your jobs in reverse chronological order. See MaxJobs. Defaults to None.
        api_version(str, optional): Specifies the version of the client tool. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.importexport.jobs.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.importexport.jobs.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="importexport",
        operation="list_jobs",
        op_kwargs={"MaxJobs": max_jobs, "Marker": marker, "APIVersion": api_version},
    )
