"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, job_id: str, api_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    This operation cancels a specified job. Only the job owner can cancel it. The operation fails if the job has already started or is complete.

    Args:
        job_id(str): A unique identifier which refers to a particular job.
        api_version(str, optional): Specifies the version of the client tool. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.importexport.job.cancel(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.importexport.job.cancel job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="importexport",
        operation="cancel_job",
        op_kwargs={"JobId": job_id, "APIVersion": api_version},
    )


async def create(
    hub,
    ctx,
    job_type: str,
    manifest: str,
    validate_only: bool,
    manifest_addendum: str = None,
    api_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation initiates the process of scheduling an upload or download of your data. You include in the request a manifest that describes the data transfer specifics. The response to the request includes a job ID, which you can use in other operations, a signature that you use to identify your storage device, and the address where you should ship your storage device.

    Args:
        job_type(str): Specifies whether the job to initiate is an import or export job.
        manifest(str): The UTF-8 encoded text of the manifest file.
        manifest_addendum(str, optional): For internal use only. Defaults to None.
        validate_only(bool): Validate the manifest and parameter values in the request but do not actually create a job.
        api_version(str, optional): Specifies the version of the client tool. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.importexport.job.create(
                ctx, job_type=value, manifest=value, validate_only=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.importexport.job.create job_type=value, manifest=value, validate_only=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="importexport",
        operation="create_job",
        op_kwargs={
            "JobType": job_type,
            "Manifest": manifest,
            "ManifestAddendum": manifest_addendum,
            "ValidateOnly": validate_only,
            "APIVersion": api_version,
        },
    )


async def update(
    hub,
    ctx,
    job_id: str,
    manifest: str,
    job_type: str,
    validate_only: bool,
    api_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    You use this operation to change the parameters specified in the original manifest file by supplying a new manifest file. The manifest file attached to this request replaces the original manifest file. You can only use the operation after a CreateJob request but before the data transfer starts and you can only use it on jobs you own.

    Args:
        job_id(str): A unique identifier which refers to a particular job.
        manifest(str): The UTF-8 encoded text of the manifest file.
        job_type(str): Specifies whether the job to initiate is an import or export job.
        validate_only(bool): Validate the manifest and parameter values in the request but do not actually create a job.
        api_version(str, optional): Specifies the version of the client tool. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.importexport.job.update(
                ctx, job_id=value, manifest=value, job_type=value, validate_only=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.importexport.job.update job_id=value, manifest=value, job_type=value, validate_only=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="importexport",
        operation="update_job",
        op_kwargs={
            "JobId": job_id,
            "Manifest": manifest,
            "JobType": job_type,
            "ValidateOnly": validate_only,
            "APIVersion": api_version,
        },
    )
