"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    instance_profile_name: str,
    client_token: str,
    description: str = None,
    instance_types: List = None,
    security_group_ids: List = None,
    subnet_id: str = None,
    logging: Dict = None,
    key_pair: str = None,
    terminate_instance_on_failure: bool = None,
    sns_topic_arn: str = None,
    resource_tags: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.

    Args:
        name(str): The name of the infrastructure configuration.
        description(str, optional): The description of the infrastructure configuration. Defaults to None.
        instance_types(List, optional): The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability. Defaults to None.
        instance_profile_name(str): The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
        security_group_ids(List, optional): The security group IDs to associate with the instance used to customize your Amazon EC2 AMI. Defaults to None.
        subnet_id(str, optional): The subnet ID in which to place the instance used to customize your Amazon EC2 AMI. Defaults to None.
        logging(Dict, optional): The logging configuration of the infrastructure configuration. Defaults to None.
        key_pair(str, optional): The key pair of the infrastructure configuration. This can be used to log on to and debug the instance used to create your image. Defaults to None.
        terminate_instance_on_failure(bool, optional): The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails. Defaults to None.
        sns_topic_arn(str, optional): The SNS topic on which to send image build events. Defaults to None.
        resource_tags(Dict, optional): The tags attached to the resource created by Image Builder. Defaults to None.
        tags(Dict, optional): The tags of the infrastructure configuration. Defaults to None.
        client_token(str): The idempotency token used to make this request idempotent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.infrastructure_configuration.create(
                ctx, name=value, instance_profile_name=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.infrastructure_configuration.create name=value, instance_profile_name=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="create_infrastructure_configuration",
        op_kwargs={
            "name": name,
            "description": description,
            "instanceTypes": instance_types,
            "instanceProfileName": instance_profile_name,
            "securityGroupIds": security_group_ids,
            "subnetId": subnet_id,
            "logging": logging,
            "keyPair": key_pair,
            "terminateInstanceOnFailure": terminate_instance_on_failure,
            "snsTopicArn": sns_topic_arn,
            "resourceTags": resource_tags,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def delete(hub, ctx, infrastructure_configuration_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes an infrastructure configuration.

    Args:
        infrastructure_configuration_arn(str): The Amazon Resource Name (ARN) of the infrastructure configuration to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.infrastructure_configuration.delete(
                ctx, infrastructure_configuration_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.infrastructure_configuration.delete infrastructure_configuration_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="delete_infrastructure_configuration",
        op_kwargs={"infrastructureConfigurationArn": infrastructure_configuration_arn},
    )


async def get(hub, ctx, infrastructure_configuration_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets an infrastructure configuration.

    Args:
        infrastructure_configuration_arn(str): The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.infrastructure_configuration.get(
                ctx, infrastructure_configuration_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.infrastructure_configuration.get infrastructure_configuration_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="get_infrastructure_configuration",
        op_kwargs={"infrastructureConfigurationArn": infrastructure_configuration_arn},
    )


async def list_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of infrastructure configurations.

    Args:
        filters(List, optional): The filters. Defaults to None.
        max_results(int, optional): The maximum items to return in a request. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. This is the NextToken from a previously truncated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.infrastructure_configuration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.infrastructure_configuration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="list_infrastructure_configurations",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    infrastructure_configuration_arn: str,
    instance_profile_name: str,
    client_token: str,
    description: str = None,
    instance_types: List = None,
    security_group_ids: List = None,
    subnet_id: str = None,
    logging: Dict = None,
    key_pair: str = None,
    terminate_instance_on_failure: bool = None,
    sns_topic_arn: str = None,
    resource_tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.

    Args:
        infrastructure_configuration_arn(str): The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.
        description(str, optional): The description of the infrastructure configuration. Defaults to None.
        instance_types(List, optional): The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability. Defaults to None.
        instance_profile_name(str): The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
        security_group_ids(List, optional): The security group IDs to associate with the instance used to customize your Amazon EC2 AMI. Defaults to None.
        subnet_id(str, optional): The subnet ID to place the instance used to customize your Amazon EC2 AMI in. Defaults to None.
        logging(Dict, optional): The logging configuration of the infrastructure configuration. Defaults to None.
        key_pair(str, optional): The key pair of the infrastructure configuration. This can be used to log on to and debug the instance used to create your image. Defaults to None.
        terminate_instance_on_failure(bool, optional): The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails. Defaults to None.
        sns_topic_arn(str, optional): The SNS topic on which to send image build events. Defaults to None.
        client_token(str): The idempotency token used to make this request idempotent.
        resource_tags(Dict, optional): The tags attached to the resource created by Image Builder. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.infrastructure_configuration.update(
                ctx,
                infrastructure_configuration_arn=value,
                instance_profile_name=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.infrastructure_configuration.update infrastructure_configuration_arn=value, instance_profile_name=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="update_infrastructure_configuration",
        op_kwargs={
            "infrastructureConfigurationArn": infrastructure_configuration_arn,
            "description": description,
            "instanceTypes": instance_types,
            "instanceProfileName": instance_profile_name,
            "securityGroupIds": security_group_ids,
            "subnetId": subnet_id,
            "logging": logging,
            "keyPair": key_pair,
            "terminateInstanceOnFailure": terminate_instance_on_failure,
            "snsTopicArn": sns_topic_arn,
            "clientToken": client_token,
            "resourceTags": resource_tags,
        },
    )
