"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    semantic_version: str,
    components: List,
    parent_image: str,
    client_token: str,
    description: str = None,
    block_device_mappings: List = None,
    tags: Dict = None,
    working_directory: str = None,
    additional_instance_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.

    Args:
        name(str):  The name of the image recipe.
        description(str, optional):  The description of the image recipe. Defaults to None.
        semantic_version(str): The semantic version of the image recipe. This version follows the semantic version syntax.  The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.  Assignment: For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number, and that is not open for updates.  Patterns: You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01. .
        components(List): The components of the image recipe.
        parent_image(str): The parent image of the image recipe. The value of the string can be the ARN of the parent image or an AMI ID. The format for the ARN follows this example: arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.
        block_device_mappings(List, optional): The block device mappings of the image recipe. Defaults to None.
        tags(Dict, optional):  The tags of the image recipe. Defaults to None.
        working_directory(str, optional): The working directory used during build and test workflows. Defaults to None.
        additional_instance_configuration(Dict, optional): Specify additional settings and launch scripts for your build instances. Defaults to None.
        client_token(str): The idempotency token used to make this request idempotent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.recipe.init.create(
                ctx,
                name=value,
                semantic_version=value,
                components=value,
                parent_image=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.recipe.init.create name=value, semantic_version=value, components=value, parent_image=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="create_image_recipe",
        op_kwargs={
            "name": name,
            "description": description,
            "semanticVersion": semantic_version,
            "components": components,
            "parentImage": parent_image,
            "blockDeviceMappings": block_device_mappings,
            "tags": tags,
            "workingDirectory": working_directory,
            "additionalInstanceConfiguration": additional_instance_configuration,
            "clientToken": client_token,
        },
    )


async def delete(hub, ctx, image_recipe_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes an image recipe.

    Args:
        image_recipe_arn(str): The Amazon Resource Name (ARN) of the image recipe to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.recipe.init.delete(
                ctx, image_recipe_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.recipe.init.delete image_recipe_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="delete_image_recipe",
        op_kwargs={"imageRecipeArn": image_recipe_arn},
    )


async def get(hub, ctx, image_recipe_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets an image recipe.

    Args:
        image_recipe_arn(str): The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.recipe.init.get(ctx, image_recipe_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.recipe.init.get image_recipe_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="get_image_recipe",
        op_kwargs={"imageRecipeArn": image_recipe_arn},
    )


async def list_all(
    hub,
    ctx,
    owner: str = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of image recipes.

    Args:
        owner(str, optional): The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers. Defaults to None.
        filters(List, optional): The filters. Defaults to None.
        max_results(int, optional): The maximum items to return in a request. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. This is the NextToken from a previously truncated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.recipe.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.recipe.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="list_image_recipes",
        op_kwargs={
            "owner": owner,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
