"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    infrastructure_configuration_arn: str,
    client_token: str,
    description: str = None,
    image_recipe_arn: str = None,
    container_recipe_arn: str = None,
    distribution_configuration_arn: str = None,
    image_tests_configuration: Dict = None,
    enhanced_image_metadata_enabled: bool = None,
    schedule: Dict = None,
    status: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.

    Args:
        name(str):  The name of the image pipeline.
        description(str, optional):  The description of the image pipeline. Defaults to None.
        image_recipe_arn(str, optional):  The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline. Defaults to None.
        container_recipe_arn(str, optional): The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline. Defaults to None.
        infrastructure_configuration_arn(str):  The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.
        distribution_configuration_arn(str, optional):  The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline. Defaults to None.
        image_tests_configuration(Dict, optional):  The image test configuration of the image pipeline. Defaults to None.
        enhanced_image_metadata_enabled(bool, optional):  Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default. Defaults to None.
        schedule(Dict, optional):  The schedule of the image pipeline. Defaults to None.
        status(str, optional):  The status of the image pipeline. Defaults to None.
        tags(Dict, optional):  The tags of the image pipeline. Defaults to None.
        client_token(str):  The idempotency token used to make this request idempotent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.pipeline.init.create(
                ctx, name=value, infrastructure_configuration_arn=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.pipeline.init.create name=value, infrastructure_configuration_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="create_image_pipeline",
        op_kwargs={
            "name": name,
            "description": description,
            "imageRecipeArn": image_recipe_arn,
            "containerRecipeArn": container_recipe_arn,
            "infrastructureConfigurationArn": infrastructure_configuration_arn,
            "distributionConfigurationArn": distribution_configuration_arn,
            "imageTestsConfiguration": image_tests_configuration,
            "enhancedImageMetadataEnabled": enhanced_image_metadata_enabled,
            "schedule": schedule,
            "status": status,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def delete(hub, ctx, image_pipeline_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes an image pipeline.

    Args:
        image_pipeline_arn(str): The Amazon Resource Name (ARN) of the image pipeline to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.pipeline.init.delete(
                ctx, image_pipeline_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.pipeline.init.delete image_pipeline_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="delete_image_pipeline",
        op_kwargs={"imagePipelineArn": image_pipeline_arn},
    )


async def get(hub, ctx, image_pipeline_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets an image pipeline.

    Args:
        image_pipeline_arn(str): The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.pipeline.init.get(
                ctx, image_pipeline_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.pipeline.init.get image_pipeline_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="get_image_pipeline",
        op_kwargs={"imagePipelineArn": image_pipeline_arn},
    )


async def list_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of image pipelines.

    Args:
        filters(List, optional): The filters. Defaults to None.
        max_results(int, optional): The maximum items to return in a request. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. This is the NextToken from a previously truncated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.pipeline.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.pipeline.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="list_image_pipelines",
        op_kwargs={
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    image_pipeline_arn: str,
    infrastructure_configuration_arn: str,
    client_token: str,
    description: str = None,
    image_recipe_arn: str = None,
    container_recipe_arn: str = None,
    distribution_configuration_arn: str = None,
    image_tests_configuration: Dict = None,
    enhanced_image_metadata_enabled: bool = None,
    schedule: Dict = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.  UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required properties in the update request, not just the properties that have changed.

    Args:
        image_pipeline_arn(str): The Amazon Resource Name (ARN) of the image pipeline that you want to update.
        description(str, optional): The description of the image pipeline. Defaults to None.
        image_recipe_arn(str, optional): The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline. Defaults to None.
        container_recipe_arn(str, optional): The Amazon Resource Name (ARN) of the container pipeline to update. Defaults to None.
        infrastructure_configuration_arn(str): The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images updated by this image pipeline.
        distribution_configuration_arn(str, optional): The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images updated by this image pipeline. Defaults to None.
        image_tests_configuration(Dict, optional): The image test configuration of the image pipeline. Defaults to None.
        enhanced_image_metadata_enabled(bool, optional):  Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default. Defaults to None.
        schedule(Dict, optional): The schedule of the image pipeline. Defaults to None.
        status(str, optional): The status of the image pipeline. Defaults to None.
        client_token(str): The idempotency token used to make this request idempotent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.pipeline.init.update(
                ctx,
                image_pipeline_arn=value,
                infrastructure_configuration_arn=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.pipeline.init.update image_pipeline_arn=value, infrastructure_configuration_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="update_image_pipeline",
        op_kwargs={
            "imagePipelineArn": image_pipeline_arn,
            "description": description,
            "imageRecipeArn": image_recipe_arn,
            "containerRecipeArn": container_recipe_arn,
            "infrastructureConfigurationArn": infrastructure_configuration_arn,
            "distributionConfigurationArn": distribution_configuration_arn,
            "imageTestsConfiguration": image_tests_configuration,
            "enhancedImageMetadataEnabled": enhanced_image_metadata_enabled,
            "schedule": schedule,
            "status": status,
            "clientToken": client_token,
        },
    )
