"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, image_pipeline_arn: str, client_token: str) -> Dict:
    r"""
    **Autogenerated function**

     Manually triggers a pipeline to create an image.

    Args:
        image_pipeline_arn(str): The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.
        client_token(str): The idempotency token used to make this request idempotent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.pipeline.execution.start(
                ctx, image_pipeline_arn=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.pipeline.execution.start image_pipeline_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="start_image_pipeline_execution",
        op_kwargs={"imagePipelineArn": image_pipeline_arn, "clientToken": client_token},
    )
