"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    image_build_version_arn: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the Packages that are associated with an Image Build Version, as determined by Amazon EC2 Systems Manager Inventory at build time.

    Args:
        image_build_version_arn(str): Filter results for the ListImagePackages request by the Image Build Version ARN.
        max_results(int, optional): The maxiumum number of results to return from the ListImagePackages request. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. This is the NextToken from a previously truncated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.package.list_all(
                ctx, image_build_version_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.package.list_all image_build_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="list_image_packages",
        op_kwargs={
            "imageBuildVersionArn": image_build_version_arn,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
