"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    infrastructure_configuration_arn: str,
    client_token: str,
    image_recipe_arn: str = None,
    container_recipe_arn: str = None,
    distribution_configuration_arn: str = None,
    image_tests_configuration: Dict = None,
    enhanced_image_metadata_enabled: bool = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.

    Args:
        image_recipe_arn(str, optional):  The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed. Defaults to None.
        container_recipe_arn(str, optional): The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested. Defaults to None.
        distribution_configuration_arn(str, optional):  The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline. Defaults to None.
        infrastructure_configuration_arn(str):  The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.
        image_tests_configuration(Dict, optional):  The image tests configuration of the image. Defaults to None.
        enhanced_image_metadata_enabled(bool, optional):  Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default. Defaults to None.
        tags(Dict, optional):  The tags of the image. Defaults to None.
        client_token(str):  The idempotency token used to make this request idempotent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.init.create(
                ctx, infrastructure_configuration_arn=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.init.create infrastructure_configuration_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="create_image",
        op_kwargs={
            "imageRecipeArn": image_recipe_arn,
            "containerRecipeArn": container_recipe_arn,
            "distributionConfigurationArn": distribution_configuration_arn,
            "infrastructureConfigurationArn": infrastructure_configuration_arn,
            "imageTestsConfiguration": image_tests_configuration,
            "enhancedImageMetadataEnabled": enhanced_image_metadata_enabled,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def delete(hub, ctx, image_build_version_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes an image.

    Args:
        image_build_version_arn(str): The Amazon Resource Name (ARN) of the image to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.init.delete(
                ctx, image_build_version_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.init.delete image_build_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="delete_image",
        op_kwargs={"imageBuildVersionArn": image_build_version_arn},
    )


async def get(hub, ctx, image_build_version_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets an image.

    Args:
        image_build_version_arn(str): The Amazon Resource Name (ARN) of the image that you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.init.get(ctx, image_build_version_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.init.get image_build_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="get_image",
        op_kwargs={"imageBuildVersionArn": image_build_version_arn},
    )


async def list_all(
    hub,
    ctx,
    owner: str = None,
    filters: List = None,
    by_name: bool = None,
    max_results: int = None,
    next_token: str = None,
    include_deprecated: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the list of images that you have access to.

    Args:
        owner(str, optional): The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers. Defaults to None.
        filters(List, optional): The filters. Defaults to None.
        by_name(bool, optional): Requests a list of images with a specific recipe name. Defaults to None.
        max_results(int, optional): The maximum items to return in a request. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. This is the NextToken from a previously truncated response. Defaults to None.
        include_deprecated(bool, optional): Includes deprecated images in the response list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="list_images",
        op_kwargs={
            "owner": owner,
            "filters": filters,
            "byName": by_name,
            "maxResults": max_results,
            "nextToken": next_token,
            "includeDeprecated": include_deprecated,
        },
    )
