"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, image_build_version_arn: str, client_token: str) -> Dict:
    r"""
    **Autogenerated function**

    CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.

    Args:
        image_build_version_arn(str): The Amazon Resource Name (ARN) of the image whose creation you want to cancel.
        client_token(str): The idempotency token used to make this request idempotent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.creation.cancel(
                ctx, image_build_version_arn=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.creation.cancel image_build_version_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="cancel_image_creation",
        op_kwargs={
            "imageBuildVersionArn": image_build_version_arn,
            "clientToken": client_token,
        },
    )
