"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    image_version_arn: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of image build versions.

    Args:
        image_version_arn(str): The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.
        filters(List, optional): The filters. Defaults to None.
        max_results(int, optional): The maximum items to return in a request. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. This is the NextToken from a previously truncated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.image.build_version.list_all(
                ctx, image_version_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.image.build_version.list_all image_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="list_image_build_versions",
        op_kwargs={
            "imageVersionArn": image_version_arn,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
