"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, container_recipe_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the policy for a container recipe.

    Args:
        container_recipe_arn(str): The Amazon Resource Name (ARN) of the container recipe for the policy being requested.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.container_recipe.policy.get(
                ctx, container_recipe_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.container_recipe.policy.get container_recipe_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="get_container_recipe_policy",
        op_kwargs={"containerRecipeArn": container_recipe_arn},
    )


async def put(hub, ctx, container_recipe_arn: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API PutContainerImagePolicy, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.

    Args:
        container_recipe_arn(str): The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.
        policy(str): The policy to apply to the container recipe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.container_recipe.policy.put(
                ctx, container_recipe_arn=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.container_recipe.policy.put container_recipe_arn=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="put_container_recipe_policy",
        op_kwargs={"containerRecipeArn": container_recipe_arn, "policy": policy},
    )
