"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    container_type: str,
    name: str,
    semantic_version: str,
    components: List,
    parent_image: str,
    target_repository: Dict,
    client_token: str,
    description: str = None,
    instance_configuration: Dict = None,
    dockerfile_template_data: str = None,
    dockerfile_template_uri: str = None,
    platform_override: str = None,
    image_os_version_override: str = None,
    tags: Dict = None,
    working_directory: str = None,
    kms_key_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.

    Args:
        container_type(str): The type of container to create.
        name(str): The name of the container recipe.
        description(str, optional): The description of the container recipe. Defaults to None.
        semantic_version(str): The semantic version of the container recipe. This version follows the semantic version syntax.  The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.  Assignment: For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number, and that is not open for updates.  Patterns: You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01. .
        components(List): Components for build and test that are included in the container recipe.
        instance_configuration(Dict, optional): A group of options that can be used to configure an instance for building and testing container images. Defaults to None.
        dockerfile_template_data(str, optional): The Dockerfile template used to build your image as an inline data blob. Defaults to None.
        dockerfile_template_uri(str, optional): The Amazon S3 URI for the Dockerfile that will be used to build your container image. Defaults to None.
        platform_override(str, optional): Specifies the operating system platform when you use a custom source image. Defaults to None.
        image_os_version_override(str, optional): Specifies the operating system version for the source image. Defaults to None.
        parent_image(str): The source image for the container recipe.
        tags(Dict, optional): Tags that are attached to the container recipe. Defaults to None.
        working_directory(str, optional): The working directory for use during build and test workflows. Defaults to None.
        target_repository(Dict): The destination repository for the container image.
        kms_key_id(str, optional): Identifies which KMS key is used to encrypt the container image. Defaults to None.
        client_token(str): The client token used to make this request idempotent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.container_recipe.init.create(
                ctx,
                container_type=value,
                name=value,
                semantic_version=value,
                components=value,
                parent_image=value,
                target_repository=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.container_recipe.init.create container_type=value, name=value, semantic_version=value, components=value, parent_image=value, target_repository=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="create_container_recipe",
        op_kwargs={
            "containerType": container_type,
            "name": name,
            "description": description,
            "semanticVersion": semantic_version,
            "components": components,
            "instanceConfiguration": instance_configuration,
            "dockerfileTemplateData": dockerfile_template_data,
            "dockerfileTemplateUri": dockerfile_template_uri,
            "platformOverride": platform_override,
            "imageOsVersionOverride": image_os_version_override,
            "parentImage": parent_image,
            "tags": tags,
            "workingDirectory": working_directory,
            "targetRepository": target_repository,
            "kmsKeyId": kms_key_id,
            "clientToken": client_token,
        },
    )


async def delete(hub, ctx, container_recipe_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a container recipe.

    Args:
        container_recipe_arn(str): The Amazon Resource Name (ARN) of the container recipe to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.container_recipe.init.delete(
                ctx, container_recipe_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.container_recipe.init.delete container_recipe_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="delete_container_recipe",
        op_kwargs={"containerRecipeArn": container_recipe_arn},
    )


async def get(hub, ctx, container_recipe_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a container recipe.

    Args:
        container_recipe_arn(str): The Amazon Resource Name (ARN) of the container recipe to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.container_recipe.init.get(
                ctx, container_recipe_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.container_recipe.init.get container_recipe_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="get_container_recipe",
        op_kwargs={"containerRecipeArn": container_recipe_arn},
    )


async def list_all(
    hub,
    ctx,
    owner: str = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of container recipes.

    Args:
        owner(str, optional): Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account. Defaults to None.
        filters(List, optional): Request filters that are used to narrow the list of container images that are returned. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the list. Defaults to None.
        next_token(str, optional): Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.container_recipe.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.container_recipe.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="list_container_recipes",
        op_kwargs={
            "owner": owner,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
