"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, component_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets a component policy.

    Args:
        component_arn(str): The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.component.policy.get(ctx, component_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.component.policy.get component_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="get_component_policy",
        op_kwargs={"componentArn": component_arn},
    )


async def put(hub, ctx, component_arn: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

     Applies a policy to a component. We recommend that you call the RAM API CreateResourceShare to share resources. If you call the Image Builder API PutComponentPolicy, you must also call the RAM API PromoteResourceShareCreatedFromPolicy in order for the resource to be visible to all principals with whom the resource is shared.

    Args:
        component_arn(str): The Amazon Resource Name (ARN) of the component that this policy should be applied to.
        policy(str): The policy to apply.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.component.policy.put(
                ctx, component_arn=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.component.policy.put component_arn=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="put_component_policy",
        op_kwargs={"componentArn": component_arn, "policy": policy},
    )
