"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def create(
    hub,
    ctx,
    name: str,
    semantic_version: str,
    platform: str,
    client_token: str,
    description: str = None,
    change_description: str = None,
    supported_os_versions: List = None,
    data: str = None,
    uri: str = None,
    kms_key_id: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new component that can be used to build, validate, test, and assess your image.

    Args:
        name(str): The name of the component.
        semantic_version(str): The semantic version of the component. This version follows the semantic version syntax.  The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.  Assignment: For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number, and that is not open for updates.  Patterns: You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01. .
        description(str, optional): The description of the component. Describes the contents of the component. Defaults to None.
        change_description(str, optional): The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component. Defaults to None.
        platform(str): The platform of the component.
        supported_os_versions(List, optional):  The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the parent image OS version during image recipe creation. Defaults to None.
        data(str, optional): The data of the component. Used to specify the data inline. Either data or uri can be used to specify the data within the component. Defaults to None.
        uri(str, optional): The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either data or uri can be used to specify the data within the component. Defaults to None.
        kms_key_id(str, optional): The ID of the KMS key that should be used to encrypt this component. Defaults to None.
        tags(Dict, optional): The tags of the component. Defaults to None.
        client_token(str): The idempotency token of the component.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.component.init.create(ctx, name=value, semantic_version=value, platform=value, client_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.component.init.create name=value, semantic_version=value, platform=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="create_component",
        op_kwargs={
            "name": name,
            "semanticVersion": semantic_version,
            "description": description,
            "changeDescription": change_description,
            "platform": platform,
            "supportedOsVersions": supported_os_versions,
            "data": data,
            "uri": uri,
            "kmsKeyId": kms_key_id,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def delete(hub, ctx, component_build_version_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a component build version.

    Args:
        component_build_version_arn(str): The Amazon Resource Name (ARN) of the component build version to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.component.init.delete(ctx, component_build_version_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.component.init.delete component_build_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="delete_component",
        op_kwargs={"componentBuildVersionArn": component_build_version_arn},
    )


async def get(hub, ctx, component_build_version_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets a component object.

    Args:
        component_build_version_arn(str): The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires "/\d+$" suffix.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.component.init.get(ctx, component_build_version_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.component.init.get component_build_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="get_component",
        op_kwargs={"componentBuildVersionArn": component_build_version_arn},
    )


async def import_(
    hub,
    ctx,
    name: str,
    semantic_version: str,
    type_: str,
    format_: str,
    platform: str,
    client_token: str,
    description: str = None,
    change_description: str = None,
    data: str = None,
    uri: str = None,
    kms_key_id: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Imports a component and transforms its data into a component document.

    Args:
        name(str):  The name of the component.
        semantic_version(str): The semantic version of the component. This version follows the semantic version syntax.  The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.  Filtering: When you retrieve or reference a resource with a semantic version, you can use wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder automatically uses a wildcard for that, if applicable. .
        description(str, optional): The description of the component. Describes the contents of the component. Defaults to None.
        change_description(str, optional): The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component. Defaults to None.
        type_(str): The type of the component denotes whether the component is used to build the image, or only to test it.
        format_(str): The format of the resource that you want to import as a component.
        platform(str): The platform of the component.
        data(str, optional): The data of the component. Used to specify the data inline. Either data or uri can be used to specify the data within the component. Defaults to None.
        uri(str, optional): The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either data or uri can be used to specify the data within the component. Defaults to None.
        kms_key_id(str, optional): The ID of the KMS key that should be used to encrypt this component. Defaults to None.
        tags(Dict, optional): The tags of the component. Defaults to None.
        client_token(str): The idempotency token of the component.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.component.init.import(ctx, name=value, semantic_version=value, type_=value, format_=value, platform=value, client_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.component.init.import name=value, semantic_version=value, type_=value, format_=value, platform=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="import_component",
        op_kwargs={
            "name": name,
            "semanticVersion": semantic_version,
            "description": description,
            "changeDescription": change_description,
            "type": type_,
            "format": format_,
            "platform": platform,
            "data": data,
            "uri": uri,
            "kmsKeyId": kms_key_id,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def list_all(
    hub,
    ctx,
    owner: str = None,
    filters: List = None,
    by_name: bool = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of component build versions for the specified semantic version.  The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.  Filtering: When you retrieve or reference a resource with a semantic version, you can use wildcards (x) to filter your results. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards. For example, specifying "1.2.x", or "1.x.x" works to filter list results, but neither "1.x.2", nor "x.2.x" will work. You do not have to specify the build - Image Builder automatically uses a wildcard for that, if applicable.

    Args:
        owner(str, optional): The owner defines which components you want to list. By default, this request will only show components owned by your account. You can use this field to specify if you want to view components owned by yourself, by Amazon, or those components that have been shared with you by other customers. Defaults to None.
        filters(List, optional): The filters. Defaults to None.
        by_name(bool, optional): Returns the list of component build versions for the specified name. Defaults to None.
        max_results(int, optional): The maximum items to return in a request. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. This is the NextToken from a previously truncated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.imagebuilder.component.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.imagebuilder.component.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="imagebuilder",
        operation="list_components",
        op_kwargs={
            "owner": owner,
            "filters": filters,
            "byName": by_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
