"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, identity_store_id: str, user_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the user metadata and attributes from UserId in an identity store.

    Args:
        identity_store_id(str): The globally unique identifier for the identity store, such as d-1234567890. In this example, d- is a fixed prefix, and 1234567890 is a randomly generated string that contains number and lower case letters. This value is generated at the time that a new identity store is created.
        user_id(str): The identifier for a user in the identity store.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.identitystore.user.describe(
                ctx, identity_store_id=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.identitystore.user.describe identity_store_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="identitystore",
        operation="describe_user",
        op_kwargs={"IdentityStoreId": identity_store_id, "UserId": user_id},
    )


async def list_all(
    hub,
    ctx,
    identity_store_id: str,
    max_results: int = None,
    next_token: str = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the attribute name and value of the user that you specified in the search. We only support UserName as a valid filter attribute path currently, and filter is required. This API returns minimum attributes, including UserId and UserName in the response.

    Args:
        identity_store_id(str): The globally unique identifier for the identity store, such as d-1234567890. In this example, d- is a fixed prefix, and 1234567890 is a randomly generated string that contains number and lower case letters. This value is generated at the time that a new identity store is created.
        max_results(int, optional): The maximum number of results to be returned per request. This parameter is used in the ListUsers and ListGroups request to specify how many results to return in one page. The length limit is 50 characters. Defaults to None.
        next_token(str, optional): The pagination token used for the ListUsers and ListGroups API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page. Defaults to None.
        filters(List, optional): A list of Filter objects, which is used in the ListUsers and ListGroups request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.identitystore.user.list_all(ctx, identity_store_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.identitystore.user.list_all identity_store_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="identitystore",
        operation="list_users",
        op_kwargs={
            "IdentityStoreId": identity_store_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
        },
    )
