"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, virtual_mfa_device_name: str, path: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new virtual MFA device for the account. After creating the virtual MFA, use EnableMFADevice to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA devices, see Using a virtual MFA device in the IAM User Guide. For information about the maximum number of MFA devices you can create, see IAM and STS quotas in the IAM User Guide.  The seed information contained in the QR code and the Base32 string should be treated like any other secret access information. In other words, protect the seed information as you would your Amazon Web Services access keys or your passwords. After you provision your virtual device, you should ensure that the information is destroyed following secure procedures.

    Args:
        path(str, optional):  The path for the virtual MFA device. For more information about paths, see IAM identifiers in the IAM User Guide. This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows (through its regex pattern) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F), including most punctuation characters, digits, and upper and lowercased letters. Defaults to None.
        virtual_mfa_device_name(str): The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tags(List, optional): A list of tags that you want to attach to the new IAM virtual MFA device. Each tag consists of a key name and an associated value. For more information about tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.virtual_mfa_device.create(
                ctx, virtual_mfa_device_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.virtual_mfa_device.create virtual_mfa_device_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="create_virtual_mfa_device",
        op_kwargs={
            "Path": path,
            "VirtualMFADeviceName": virtual_mfa_device_name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, serial_number: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a virtual MFA device.   You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA devices, see DeactivateMFADevice.

    Args:
        serial_number(str): The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the same as the ARN. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.virtual_mfa_device.delete(ctx, serial_number=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.virtual_mfa_device.delete serial_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_virtual_mfa_device",
        op_kwargs={"SerialNumber": serial_number},
    )


async def list_all(
    hub, ctx, assignment_status: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the virtual MFA devices defined in the account by assignment status. If you do not specify an assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be Assigned, Unassigned, or Any.  IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a virtual MFA device, see ListVirtualMFADevices.  You can paginate the results using the MaxItems and Marker parameters.

    Args:
        assignment_status(str, optional):  The status (Unassigned or Assigned) of the devices to list. If you do not specify an AssignmentStatus, the operation defaults to Any, which lists both assigned and unassigned virtual MFA devices.,. Defaults to None.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.virtual_mfa_device.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.virtual_mfa_device.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_virtual_mfa_devices",
        op_kwargs={
            "AssignmentStatus": assignment_status,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )
