"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def add(hub, ctx, group_name: str, user_name: str) -> None:
    r"""
    **Autogenerated function**

    Adds the specified user to the specified group.

    Args:
        group_name(str): The name of the group to update. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        user_name(str): The name of the user to add. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.to_group.add(ctx, group_name=value, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.to_group.add group_name=value, user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="add_user_to_group",
        op_kwargs={"GroupName": group_name, "UserName": user_name},
    )
