"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def attach(hub, ctx, user_name: str, policy_arn: str) -> None:
    r"""
    **Autogenerated function**

    Attaches the specified managed policy to the specified user. You use this operation to attach a managed policy to a user. To embed an inline policy in a user, use PutUserPolicy. As a best practice, you can validate your IAM policies. To learn more, see Validating IAM policies in the IAM User Guide. For more information about policies, see Managed policies and inline policies in the IAM User Guide.

    Args:
        user_name(str): The name (friendly name, not ARN) of the IAM user to attach the policy to. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_arn(str): The Amazon Resource Name (ARN) of the IAM policy you want to attach. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.policy.attach(ctx, user_name=value, policy_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.policy.attach user_name=value, policy_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="attach_user_policy",
        op_kwargs={"UserName": user_name, "PolicyArn": policy_arn},
    )


async def delete(hub, ctx, user_name: str, policy_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified inline policy that is embedded in the specified IAM user. A user can also have managed policies attached to it. To detach a managed policy from a user, use DetachUserPolicy. For more information about policies, refer to Managed policies and inline policies in the IAM User Guide.

    Args:
        user_name(str): The name (friendly name, not ARN) identifying the user that the policy is embedded in. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_name(str): The name identifying the policy document to delete. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.policy.delete(ctx, user_name=value, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.policy.delete user_name=value, policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_user_policy",
        op_kwargs={"UserName": user_name, "PolicyName": policy_name},
    )


async def detach(hub, ctx, user_name: str, policy_arn: str) -> None:
    r"""
    **Autogenerated function**

    Removes the specified managed policy from the specified user. A user can also have inline policies embedded with it. To delete an inline policy, use DeleteUserPolicy. For information about policies, see Managed policies and inline policies in the IAM User Guide.

    Args:
        user_name(str): The name (friendly name, not ARN) of the IAM user to detach the policy from. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_arn(str): The Amazon Resource Name (ARN) of the IAM policy you want to detach. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.policy.detach(ctx, user_name=value, policy_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.policy.detach user_name=value, policy_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="detach_user_policy",
        op_kwargs={"UserName": user_name, "PolicyArn": policy_arn},
    )


async def get(hub, ctx, user_name: str, policy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified inline policy document that is embedded in the specified IAM user.  Policies returned by this operation are URL-encoded compliant with RFC 3986. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the decode method of the java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs provide similar functionality.  An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached to a user, use GetPolicy to determine the policy's default version. Then use GetPolicyVersion to retrieve the policy document. For more information about policies, see Managed policies and inline policies in the IAM User Guide.

    Args:
        user_name(str): The name of the user who the policy is associated with. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_name(str): The name of the policy document to get. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.policy.get(ctx, user_name=value, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.policy.get user_name=value, policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="get_user_policy",
        op_kwargs={"UserName": user_name, "PolicyName": policy_name},
    )


async def list_all(
    hub, ctx, user_name: str, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the names of the inline policies embedded in the specified IAM user. An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a user, use ListAttachedUserPolicies. For more information about policies, see Managed policies and inline policies in the IAM User Guide. You can paginate the results using the MaxItems and Marker parameters. If there are no inline policies embedded with the specified user, the operation returns an empty list.

    Args:
        user_name(str): The name of the user to list policies for. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.policy.list_all(ctx, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.policy.list_all user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_user_policies",
        op_kwargs={"UserName": user_name, "Marker": marker, "MaxItems": max_items},
    )


async def put(hub, ctx, user_name: str, policy_name: str, policy_document: str) -> None:
    r"""
    **Autogenerated function**

    Adds or updates an inline policy document that is embedded in the specified IAM user. An IAM user can also have a managed policy attached to it. To attach a managed policy to a user, use AttachUserPolicy. To create a new managed policy, use CreatePolicy. For information about policies, see Managed policies and inline policies in the IAM User Guide. For information about the maximum number of inline policies that you can embed in a user, see IAM and STS quotas in the IAM User Guide.  Because policy documents can be large, you should use POST rather than GET when calling PutUserPolicy. For general information about using the Query API with IAM, see Making query requests in the IAM User Guide.

    Args:
        user_name(str): The name of the user to associate the policy with. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_name(str): The name of the policy document. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_document(str): The policy document. You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.policy.put(
                ctx, user_name=value, policy_name=value, policy_document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.policy.put user_name=value, policy_name=value, policy_document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="put_user_policy",
        op_kwargs={
            "UserName": user_name,
            "PolicyName": policy_name,
            "PolicyDocument": policy_document,
        },
    )
