"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(hub, ctx, user_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the permissions boundary for the specified IAM user.  Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all the actions granted in its permissions policies.

    Args:
        user_name(str): The name (friendly name, not ARN) of the IAM user from which you want to remove the permissions boundary.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.permission_boundary.delete(ctx, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.permission_boundary.delete user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_user_permissions_boundary",
        op_kwargs={"UserName": user_name},
    )


async def put(hub, ctx, user_name: str, permissions_boundary: str) -> None:
    r"""
    **Autogenerated function**

    Adds or updates the policy that is specified as the IAM user's permissions boundary. You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for a user. Use the boundary to control the maximum permissions that the user can have. Setting a permissions boundary is an advanced feature that can affect the permissions for the user.  Policies that are used as permissions boundaries do not provide permissions. You must also attach a permissions policy to the user. To learn how the effective permissions for a user are evaluated, see IAM JSON policy evaluation logic in the IAM User Guide.

    Args:
        user_name(str): The name (friendly name, not ARN) of the IAM user for which you want to set the permissions boundary.
        permissions_boundary(str): The ARN of the policy that is used to set the permissions boundary for the user.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.user.permission_boundary.put(
                ctx, user_name=value, permissions_boundary=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.user.permission_boundary.put user_name=value, permissions_boundary=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="put_user_permissions_boundary",
        op_kwargs={"UserName": user_name, "PermissionsBoundary": permissions_boundary},
    )
