"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, user_name: str, ssh_public_key_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified SSH public key. The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see Set up CodeCommit for SSH connections in the CodeCommit User Guide.

    Args:
        user_name(str): The name of the IAM user associated with the SSH public key. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        ssh_public_key_id(str): The unique identifier for the SSH public key. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.ssh_public_key.delete(
                ctx, user_name=value, ssh_public_key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.ssh_public_key.delete user_name=value, ssh_public_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_ssh_public_key",
        op_kwargs={"UserName": user_name, "SSHPublicKeyId": ssh_public_key_id},
    )


async def get(hub, ctx, user_name: str, ssh_public_key_id: str, encoding: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified SSH public key, including metadata about the key. The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see Set up CodeCommit for SSH connections in the CodeCommit User Guide.

    Args:
        user_name(str): The name of the IAM user associated with the SSH public key. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        ssh_public_key_id(str): The unique identifier for the SSH public key. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.
        encoding(str): Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use SSH. To retrieve the public key in PEM format, use PEM.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.ssh_public_key.get(
                ctx, user_name=value, ssh_public_key_id=value, encoding=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.ssh_public_key.get user_name=value, ssh_public_key_id=value, encoding=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="get_ssh_public_key",
        op_kwargs={
            "UserName": user_name,
            "SSHPublicKeyId": ssh_public_key_id,
            "Encoding": encoding,
        },
    )


async def list_all(
    hub, ctx, user_name: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the SSH public keys associated with the specified IAM user. If none exists, the operation returns an empty list. The SSH public keys returned by this operation are used only for authenticating the IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see Set up CodeCommit for SSH connections in the CodeCommit User Guide. Although each user is limited to a small number of keys, you can still paginate the results using the MaxItems and Marker parameters.

    Args:
        user_name(str, optional): The name of the IAM user to list SSH public keys for. If none is specified, the UserName field is determined implicitly based on the Amazon Web Services access key used to sign the request. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.ssh_public_key.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.ssh_public_key.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_ssh_public_keys",
        op_kwargs={"UserName": user_name, "Marker": marker, "MaxItems": max_items},
    )


async def update(hub, ctx, user_name: str, ssh_public_key_id: str, status: str) -> None:
    r"""
    **Autogenerated function**

    Sets the status of an IAM user's SSH public key to active or inactive. SSH public keys that are inactive cannot be used for authentication. This operation can be used to disable a user's SSH public key as part of a key rotation work flow. The SSH public key affected by this operation is used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see Set up CodeCommit for SSH connections in the CodeCommit User Guide.

    Args:
        user_name(str): The name of the IAM user associated with the SSH public key. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        ssh_public_key_id(str): The unique identifier for the SSH public key. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.
        status(str): The status to assign to the SSH public key. Active means that the key can be used for authentication with an CodeCommit repository. Inactive means that the key cannot be used.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.ssh_public_key.update(
                ctx, user_name=value, ssh_public_key_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.ssh_public_key.update user_name=value, ssh_public_key_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_ssh_public_key",
        op_kwargs={
            "UserName": user_name,
            "SSHPublicKeyId": ssh_public_key_id,
            "Status": status,
        },
    )


async def upload(hub, ctx, user_name: str, ssh_public_key_body: str) -> Dict:
    r"""
    **Autogenerated function**

    Uploads an SSH public key and associates it with the specified IAM user. The SSH public key uploaded by this operation can be used only for authenticating the associated IAM user to an CodeCommit repository. For more information about using SSH keys to authenticate to an CodeCommit repository, see Set up CodeCommit for SSH connections in the CodeCommit User Guide.

    Args:
        user_name(str): The name of the IAM user to associate the SSH public key with. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        ssh_public_key_body(str): The SSH public key. The public key must be encoded in ssh-rsa format or PEM format. The minimum bit-length of the public key is 2048 bits. For example, you can generate a 2048-bit key, and the resulting PEM file is 1679 bytes long. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.ssh_public_key.upload(
                ctx, user_name=value, ssh_public_key_body=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.ssh_public_key.upload user_name=value, ssh_public_key_body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="upload_ssh_public_key",
        op_kwargs={"UserName": user_name, "SSHPublicKeyBody": ssh_public_key_body},
    )
