"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, certificate_id: str, user_name: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes a signing certificate associated with the specified IAM user. If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the account. Consequently, you can use this operation to manage account root user credentials even if the account has no associated IAM users.

    Args:
        user_name(str, optional): The name of the user the signing certificate belongs to. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        certificate_id(str): The ID of the signing certificate to delete. The format of this parameter, as described by its regex pattern, is a string of characters that can be upper- or lower-cased letters or digits.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.signing_certificate.delete(ctx, certificate_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.signing_certificate.delete certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_signing_certificate",
        op_kwargs={"UserName": user_name, "CertificateId": certificate_id},
    )


async def list_all(
    hub, ctx, user_name: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the signing certificates associated with the specified IAM user. If none exists, the operation returns an empty list. Although each user is limited to a small number of signing certificates, you can still paginate the results using the MaxItems and Marker parameters. If the UserName field is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request for this operation. This operation works for access keys under the account. Consequently, you can use this operation to manage account root user credentials even if the account has no associated users.

    Args:
        user_name(str, optional): The name of the IAM user whose signing certificates you want to examine. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.signing_certificate.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.signing_certificate.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_signing_certificates",
        op_kwargs={"UserName": user_name, "Marker": marker, "MaxItems": max_items},
    )


async def update(
    hub, ctx, certificate_id: str, status: str, user_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Changes the status of the specified user signing certificate from active to disabled, or vice versa. This operation can be used to disable an IAM user's signing certificate as part of a certificate rotation work flow. If the UserName field is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. This operation works for access keys under the account. Consequently, you can use this operation to manage account root user credentials even if the account has no associated users.

    Args:
        user_name(str, optional): The name of the IAM user the signing certificate belongs to. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        certificate_id(str): The ID of the signing certificate you want to update. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.
        status(str):  The status you want to assign to the certificate. Active means that the certificate can be used for programmatic calls to Amazon Web Services Inactive means that the certificate cannot be used.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.signing_certificate.update(
                ctx, certificate_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.signing_certificate.update certificate_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_signing_certificate",
        op_kwargs={
            "UserName": user_name,
            "CertificateId": certificate_id,
            "Status": status,
        },
    )


async def upload(hub, ctx, certificate_body: str, user_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Uploads an X.509 signing certificate and associates it with the specified IAM user. Some Amazon Web Services services require you to use certificates to validate requests that are signed with a corresponding private key. When you upload the certificate, its default status is Active. For information about when you would use an X.509 signing certificate, see Managing server certificates in IAM in the IAM User Guide. If the UserName is not specified, the IAM user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. This operation works for access keys under the account. Consequently, you can use this operation to manage account root user credentials even if the account has no associated users.  Because the body of an X.509 certificate can be large, you should use POST rather than GET when calling UploadSigningCertificate. For information about setting up signatures and authorization through the API, see Signing Amazon Web Services API requests in the Amazon Web Services General Reference. For general information about using the Query API with IAM, see Making query requests in the IAM User Guide.

    Args:
        user_name(str, optional): The name of the user the signing certificate is for. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        certificate_body(str): The contents of the signing certificate. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.signing_certificate.upload(ctx, certificate_body=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.signing_certificate.upload certificate_body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="upload_signing_certificate",
        op_kwargs={"UserName": user_name, "CertificateBody": certificate_body},
    )
