"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, user_name: str, service_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Generates a set of credentials consisting of a user name and password that can be used to access the service specified in the request. These credentials are generated by IAM, and can be used only for the specified service.  You can have a maximum of two sets of service-specific credentials for each supported service per user. You can create service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache Cassandra). You can reset the password to a new service-generated value by calling ResetServiceSpecificCredential. For more information about service-specific credentials, see Using IAM with CodeCommit: Git credentials, SSH keys, and Amazon Web Services access keys in the IAM User Guide.

    Args:
        user_name(str): The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        service_name(str): The name of the Amazon Web Services service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.service.specific_credential.create(
                ctx, user_name=value, service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.service.specific_credential.create user_name=value, service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="create_service_specific_credential",
        op_kwargs={"UserName": user_name, "ServiceName": service_name},
    )


async def delete(
    hub, ctx, service_specific_credential_id: str, user_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified service-specific credential.

    Args:
        user_name(str, optional): The name of the IAM user associated with the service-specific credential. If this value is not specified, then the operation assumes the user whose credentials are used to call the operation. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        service_specific_credential_id(str): The unique identifier of the service-specific credential. You can get this value by calling ListServiceSpecificCredentials. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.service.specific_credential.delete(
                ctx, service_specific_credential_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.service.specific_credential.delete service_specific_credential_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_service_specific_credential",
        op_kwargs={
            "UserName": user_name,
            "ServiceSpecificCredentialId": service_specific_credential_id,
        },
    )


async def list_all(hub, ctx, user_name: str = None, service_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the service-specific credentials associated with the specified IAM user. If none exists, the operation returns an empty list. The service-specific credentials returned by this operation are used only for authenticating the IAM user to a specific service. For more information about using service-specific credentials to authenticate to an Amazon Web Services service, see Set up service-specific credentials in the CodeCommit User Guide.

    Args:
        user_name(str, optional): The name of the user whose service-specific credentials you want information about. If this value is not specified, then the operation assumes the user whose credentials are used to call the operation. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        service_name(str, optional): Filters the returned results to only those for the specified Amazon Web Services service. If not specified, then Amazon Web Services returns service-specific credentials for all services. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.service.specific_credential.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.service.specific_credential.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_service_specific_credentials",
        op_kwargs={"UserName": user_name, "ServiceName": service_name},
    )


async def reset(
    hub, ctx, service_specific_credential_id: str, user_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Resets the password for a service-specific credential. The new password is Amazon Web Services generated and cryptographically strong. It cannot be configured by the user. Resetting the password immediately invalidates the previous password associated with this user.

    Args:
        user_name(str, optional): The name of the IAM user associated with the service-specific credential. If this value is not specified, then the operation assumes the user whose credentials are used to call the operation. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        service_specific_credential_id(str): The unique identifier of the service-specific credential. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.service.specific_credential.reset(
                ctx, service_specific_credential_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.service.specific_credential.reset service_specific_credential_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="reset_service_specific_credential",
        op_kwargs={
            "UserName": user_name,
            "ServiceSpecificCredentialId": service_specific_credential_id,
        },
    )


async def update(
    hub, ctx, service_specific_credential_id: str, status: str, user_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Sets the status of a service-specific credential to Active or Inactive. Service-specific credentials that are inactive cannot be used for authentication to the service. This operation can be used to disable a user's service-specific credential as part of a credential rotation work flow.

    Args:
        user_name(str, optional): The name of the IAM user associated with the service-specific credential. If you do not specify this value, then the operation assumes the user whose credentials are used to call the operation. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        service_specific_credential_id(str): The unique identifier of the service-specific credential. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.
        status(str): The status to be assigned to the service-specific credential.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.service.specific_credential.update(
                ctx, service_specific_credential_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.service.specific_credential.update service_specific_credential_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_service_specific_credential",
        op_kwargs={
            "UserName": user_name,
            "ServiceSpecificCredentialId": service_specific_credential_id,
            "Status": status,
        },
    )
