"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, server_certificate_name: str, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags that are attached to the specified IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see Tagging IAM resources in the IAM User Guide.  For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, Working with server certificates in the IAM User Guide.

    Args:
        server_certificate_name(str): The name of the IAM server certificate whose tags you want to see. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.server_certificate.tag.list_all(
                ctx, server_certificate_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.server_certificate.tag.list_all server_certificate_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_server_certificate_tags",
        op_kwargs={
            "ServerCertificateName": server_certificate_name,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )
