"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, server_certificate_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified server certificate. For more information about working with server certificates, see Working with server certificates in the IAM User Guide. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.   If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates, it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command to delete the certificate. For more information, see DeleteLoadBalancerListeners in the Elastic Load Balancing API Reference.

    Args:
        server_certificate_name(str): The name of the server certificate you want to delete. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.server_certificate.init.delete(
                ctx, server_certificate_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.server_certificate.init.delete server_certificate_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_server_certificate",
        op_kwargs={"ServerCertificateName": server_certificate_name},
    )


async def get(hub, ctx, server_certificate_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the specified server certificate stored in IAM. For more information about working with server certificates, see Working with server certificates in the IAM User Guide. This topic includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.

    Args:
        server_certificate_name(str): The name of the server certificate you want to retrieve information about. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.server_certificate.init.get(
                ctx, server_certificate_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.server_certificate.init.get server_certificate_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="get_server_certificate",
        op_kwargs={"ServerCertificateName": server_certificate_name},
    )


async def list_all(
    hub, ctx, path_prefix: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation returns an empty list.  You can paginate the results using the MaxItems and Marker parameters. For more information about working with server certificates, see Working with server certificates in the IAM User Guide. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.  IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a servercertificate, see GetServerCertificate.

    Args:
        path_prefix(str, optional):  The path prefix for filtering the results. For example: /company/servercerts would get all server certificates for which the path starts with /company/servercerts. This parameter is optional. If it is not included, it defaults to a slash (/), listing all server certificates. This parameter allows (through its regex pattern) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F), including most punctuation characters, digits, and upper and lowercased letters. Defaults to None.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.server_certificate.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.server_certificate.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_server_certificates",
        op_kwargs={"PathPrefix": path_prefix, "Marker": marker, "MaxItems": max_items},
    )


async def tag(hub, ctx, server_certificate_name: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds one or more tags to an IAM server certificate. If a tag with the same key name already exists, then that tag is overwritten with the new value.  For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, Working with server certificates in the IAM User Guide.  A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:    Administrative grouping and discovery - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name Project and the value MyImportantProject. Or search for all resources with the key name Cost Center and the value 41200.     Access control - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only a server certificate that has a specified tag attached. For examples of policies that show how to use tags to control access, see Control access using IAM tags in the IAM User Guide.    Cost allocation - Use tags to help track which individuals and teams are using which Amazon Web Services resources.      If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web Services always interprets the tag Value as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.

    Args:
        server_certificate_name(str): The name of the IAM server certificate to which you want to add tags. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tags(List): The list of tags that you want to attach to the IAM server certificate. Each tag consists of a key name and an associated value.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.server_certificate.init.tag(
                ctx, server_certificate_name=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.server_certificate.init.tag server_certificate_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="tag_server_certificate",
        op_kwargs={"ServerCertificateName": server_certificate_name, "Tags": tags},
    )


async def untag(hub, ctx, server_certificate_name: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes the specified tags from the IAM server certificate. For more information about tagging, see Tagging IAM resources in the IAM User Guide.  For certificates in a Region supported by Certificate Manager (ACM), we recommend that you don't use IAM server certificates. Instead, use ACM to provision, manage, and deploy your server certificates. For more information about IAM server certificates, Working with server certificates in the IAM User Guide.

    Args:
        server_certificate_name(str): The name of the IAM server certificate from which you want to remove tags. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tag_keys(List): A list of key names as a simple array of strings. The tags with matching keys are removed from the specified IAM server certificate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.server_certificate.init.untag(
                ctx, server_certificate_name=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.server_certificate.init.untag server_certificate_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="untag_server_certificate",
        op_kwargs={
            "ServerCertificateName": server_certificate_name,
            "TagKeys": tag_keys,
        },
    )


async def update(
    hub,
    ctx,
    server_certificate_name: str,
    new_path: str = None,
    new_server_certificate_name: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the name and/or the path of the specified server certificate stored in IAM. For more information about working with server certificates, see Working with server certificates in the IAM User Guide. This topic also includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM.  You should understand the implications of changing a server certificate's path or name. For more information, see Renaming a server certificate in the IAM User Guide.   The person making the request (the principal), must have permission to change the server certificate with the old name and the new name. For example, to change the certificate named ProductionCert to ProdCert, the principal must have a policy that allows them to update both certificates. If the principal has permission to update the ProductionCert group, but not the ProdCert certificate, then the update fails. For more information about permissions, see Access management in the IAM User Guide.

    Args:
        server_certificate_name(str): The name of the server certificate that you want to update. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        new_path(str, optional): The new path for the server certificate. Include this only if you are updating the server certificate's path. This parameter allows (through its regex pattern) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F), including most punctuation characters, digits, and upper and lowercased letters. Defaults to None.
        new_server_certificate_name(str, optional): The new name for the server certificate. Include this only if you are updating the server certificate's name. The name of the certificate cannot contain any spaces. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.server_certificate.init.update(
                ctx, server_certificate_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.server_certificate.init.update server_certificate_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_server_certificate",
        op_kwargs={
            "ServerCertificateName": server_certificate_name,
            "NewPath": new_path,
            "NewServerCertificateName": new_server_certificate_name,
        },
    )


async def upload(
    hub,
    ctx,
    server_certificate_name: str,
    certificate_body: str,
    private_key: str,
    path: str = None,
    certificate_chain: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Uploads a server certificate entity for the account. The server certificate entity includes a public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded. We recommend that you use Certificate Manager to provision, manage, and deploy your server certificates. With ACM you can request a certificate, deploy it to Amazon Web Services resources, and let ACM handle certificate renewals for you. Certificates provided by ACM are free. For more information about using ACM, see the Certificate Manager User Guide. For more information about working with server certificates, see Working with server certificates in the IAM User Guide. This topic includes a list of Amazon Web Services services that can use the server certificates that you manage with IAM. For information about the number of server certificates you can upload, see IAM and STS quotas in the IAM User Guide.  Because the body of the public key certificate, private key, and the certificate chain can be large, you should use POST rather than GET when calling UploadServerCertificate. For information about setting up signatures and authorization through the API, see Signing Amazon Web Services API requests in the Amazon Web Services General Reference. For general information about using the Query API with IAM, see Calling the API by making HTTP query requests in the IAM User Guide.

    Args:
        path(str, optional): The path for the server certificate. For more information about paths, see IAM identifiers in the IAM User Guide. This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows (through its regex pattern) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F), including most punctuation characters, digits, and upper and lowercased letters.   If you are uploading a server certificate specifically for use with Amazon CloudFront distributions, you must specify a path using the path parameter. The path must begin with /cloudfront and must include a trailing slash (for example, /cloudfront/test/). . Defaults to None.
        server_certificate_name(str): The name for the server certificate. Do not include the path in this value. The name of the certificate cannot contain any spaces. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        certificate_body(str): The contents of the public key certificate in PEM-encoded format. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)  .
        private_key(str): The contents of the private key in PEM-encoded format. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)  .
        certificate_chain(str, optional): The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key certificates of the chain. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)  . Defaults to None.
        tags(List, optional): A list of tags that you want to attach to the new IAM server certificate resource. Each tag consists of a key name and an associated value. For more information about tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.server_certificate.init.upload(
                ctx, server_certificate_name=value, certificate_body=value, private_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.server_certificate.init.upload server_certificate_name=value, certificate_body=value, private_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="upload_server_certificate",
        op_kwargs={
            "Path": path,
            "ServerCertificateName": server_certificate_name,
            "CertificateBody": certificate_body,
            "PrivateKey": private_key,
            "CertificateChain": certificate_chain,
            "Tags": tags,
        },
    )
