"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, global_endpoint_token_version: str) -> None:
    r"""
    **Autogenerated function**

    Sets the specified version of the global endpoint token as the token version used for the account. By default, Security Token Service (STS) is available as a global service, and all STS requests go to a single endpoint at https://sts.amazonaws.com. Amazon Web Services recommends using Regional STS endpoints to reduce latency, build in redundancy, and increase session token availability. For information about Regional endpoints for STS, see Security Token Service endpoints and quotas in the Amazon Web Services General Reference. If you make an STS call to the global endpoint, the resulting session tokens might be valid in some Regions but not others. It depends on the version that is set in this operation. Version 1 tokens are valid only in Regions that are available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might affect systems where you temporarily store tokens. For information, see Activating and deactivating STS in an Region in the IAM User Guide. To view the current session token version, see the GlobalEndpointTokenVersion entry in the response of the GetAccountSummary operation.

    Args:
        global_endpoint_token_version(str): The version of the global endpoint token. Version 1 tokens are valid only in Regions that are available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might affect systems where you temporarily store tokens. For information, see Activating and deactivating STS in an Region in the IAM User Guide.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.security_token_service_preference.set(
                ctx, global_endpoint_token_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.security_token_service_preference.set global_endpoint_token_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="set_security_token_service_preferences",
        op_kwargs={"GlobalEndpointTokenVersion": global_endpoint_token_version},
    )
