"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, saml_metadata_document: str, name: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0. The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can create an IAM role that supports Web-based single sign-on (SSO) to the Management Console or one that supports API access to Amazon Web Services. When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that the IdP sends. You must generate the metadata document using the identity management software that is used as your organization's IdP.   This operation requires Signature Version 4.   For more information, see Enabling SAML 2.0 federated users to access the Management Console and About SAML 2.0-based federation in the IAM User Guide.

    Args:
        saml_metadata_document(str): An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP. For more information, see About SAML 2.0-based federation in the IAM User Guide .
        name(str): The name of the provider to create. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tags(List, optional): A list of tags that you want to attach to the new IAM SAML provider. Each tag consists of a key name and an associated value. For more information about tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.saml_provider.init.create(
                ctx, saml_metadata_document=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.saml_provider.init.create saml_metadata_document=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="create_saml_provider",
        op_kwargs={
            "SAMLMetadataDocument": saml_metadata_document,
            "Name": name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, saml_provider_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a SAML provider resource in IAM. Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider resource ARN fails.   This operation requires Signature Version 4.

    Args:
        saml_provider_arn(str): The Amazon Resource Name (ARN) of the SAML provider to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.saml_provider.init.delete(ctx, saml_provider_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.saml_provider.init.delete saml_provider_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_saml_provider",
        op_kwargs={"SAMLProviderArn": saml_provider_arn},
    )


async def get(hub, ctx, saml_provider_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created or updated.  This operation requires Signature Version 4.

    Args:
        saml_provider_arn(str): The Amazon Resource Name (ARN) of the SAML provider resource object in IAM to get information about. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.saml_provider.init.get(ctx, saml_provider_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.saml_provider.init.get saml_provider_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="get_saml_provider",
        op_kwargs={"SAMLProviderArn": saml_provider_arn},
    )


async def list_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Lists the SAML provider resource objects defined in IAM in the account. IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a SAML provider, see GetSAMLProvider.   This operation requires Signature Version 4.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.saml_provider.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.saml_provider.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iam", operation="list_saml_providers", op_kwargs={}
    )


async def tag(hub, ctx, saml_provider_arn: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider. For more information about these providers, see About SAML 2.0-based federation . If a tag with the same key name already exists, then that tag is overwritten with the new value. A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:    Administrative grouping and discovery - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name Project and the value MyImportantProject. Or search for all resources with the key name Cost Center and the value 41200.     Access control - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only a SAML identity provider that has a specified tag attached. For examples of policies that show how to use tags to control access, see Control access using IAM tags in the IAM User Guide.      If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web Services always interprets the tag Value as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.

    Args:
        saml_provider_arn(str): The ARN of the SAML identity provider in IAM to which you want to add tags. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tags(List): The list of tags that you want to attach to the SAML identity provider in IAM. Each tag consists of a key name and an associated value.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.saml_provider.init.tag(
                ctx, saml_provider_arn=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.saml_provider.init.tag saml_provider_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="tag_saml_provider",
        op_kwargs={"SAMLProviderArn": saml_provider_arn, "Tags": tags},
    )


async def untag(hub, ctx, saml_provider_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes the specified tags from the specified Security Assertion Markup Language (SAML) identity provider in IAM. For more information about these providers, see About web identity federation. For more information about tagging, see Tagging IAM resources in the IAM User Guide.

    Args:
        saml_provider_arn(str): The ARN of the SAML identity provider in IAM from which you want to remove tags. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tag_keys(List): A list of key names as a simple array of strings. The tags with matching keys are removed from the specified SAML identity provider.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.saml_provider.init.untag(
                ctx, saml_provider_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.saml_provider.init.untag saml_provider_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="untag_saml_provider",
        op_kwargs={"SAMLProviderArn": saml_provider_arn, "TagKeys": tag_keys},
    )


async def update(hub, ctx, saml_metadata_document: str, saml_provider_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the metadata document for an existing SAML provider resource object.  This operation requires Signature Version 4.

    Args:
        saml_metadata_document(str): An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.
        saml_provider_arn(str): The Amazon Resource Name (ARN) of the SAML provider to update. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.saml_provider.init.update(
                ctx, saml_metadata_document=value, saml_provider_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.saml_provider.init.update saml_metadata_document=value, saml_provider_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_saml_provider",
        op_kwargs={
            "SAMLMetadataDocument": saml_metadata_document,
            "SAMLProviderArn": saml_provider_arn,
        },
    )
