"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def add(hub, ctx, instance_profile_name: str, role_name: str) -> None:
    r"""
    **Autogenerated function**

    Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and this quota cannot be increased. You can remove the existing role and then add a different role to an instance profile. You must then wait for the change to appear across all of Amazon Web Services because of eventual consistency. To force the change, you must disassociate the instance profile and then associate the instance profile, or you can stop your instance and then restart it.  The caller of this operation must be granted the PassRole permission on the IAM role by a permissions policy.  For more information about roles, see Working with roles. For more information about instance profiles, see About instance profiles.

    Args:
        instance_profile_name(str): The name of the instance profile to update. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        role_name(str): The name of the role to add. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.to_instance_profile.add(
                ctx, instance_profile_name=value, role_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.to_instance_profile.add instance_profile_name=value, role_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="add_role_to_instance_profile",
        op_kwargs={"InstanceProfileName": instance_profile_name, "RoleName": role_name},
    )
