"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(hub, ctx, role_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the permissions boundary for the specified IAM role.   Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone who assumes the role to perform all the actions granted in its permissions policies.

    Args:
        role_name(str): The name (friendly name, not ARN) of the IAM role from which you want to remove the permissions boundary.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.permission_boundary.delete(ctx, role_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.permission_boundary.delete role_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_role_permissions_boundary",
        op_kwargs={"RoleName": role_name},
    )


async def put(hub, ctx, role_name: str, permissions_boundary: str) -> None:
    r"""
    **Autogenerated function**

    Adds or updates the policy that is specified as the IAM role's permissions boundary. You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for a role. Use the boundary to control the maximum permissions that the role can have. Setting a permissions boundary is an advanced feature that can affect the permissions for the role. You cannot set the boundary for a service-linked role.   Policies used as permissions boundaries do not provide permissions. You must also attach a permissions policy to the role. To learn how the effective permissions for a role are evaluated, see IAM JSON policy evaluation logic in the IAM User Guide.

    Args:
        role_name(str): The name (friendly name, not ARN) of the IAM role for which you want to set the permissions boundary.
        permissions_boundary(str): The ARN of the policy that is used to set the permissions boundary for the role.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.permission_boundary.put(
                ctx, role_name=value, permissions_boundary=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.permission_boundary.put role_name=value, permissions_boundary=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="put_role_permissions_boundary",
        op_kwargs={"RoleName": role_name, "PermissionsBoundary": permissions_boundary},
    )
