"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    role_name: str,
    assume_role_policy_document: str,
    path: str = None,
    description: str = None,
    max_session_duration: int = None,
    permissions_boundary: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new role for your account. For more information about roles, see IAM roles. For information about quotas for role names and the number of roles you can create, see IAM and STS quotas in the IAM User Guide.

    Args:
        path(str, optional):  The path to the role. For more information about paths, see IAM Identifiers in the IAM User Guide. This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows (through its regex pattern) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F), including most punctuation characters, digits, and upper and lowercased letters. Defaults to None.
        role_name(str): The name of the role to create. IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case. For example, you cannot create resources named both "MyResource" and "myresource".
        assume_role_policy_document(str): The trust relationship policy document that grants an entity permission to assume the role. In IAM, you must provide a JSON policy that has been converted to a string. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)    Upon success, the response includes the same trust policy in JSON format.
        description(str, optional): A description of the role. Defaults to None.
        max_session_duration(int, optional): The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours. Anyone who assumes the role from the or API can use the DurationSeconds API parameter or the duration-seconds CLI parameter to request a longer session. The MaxSessionDuration setting determines the maximum duration that can be requested using the DurationSeconds parameter. If users don't specify a value for the DurationSeconds parameter, their security credentials are valid for one hour by default. This applies when you use the AssumeRole* API operations or the assume-role* CLI operations but does not apply when you use those operations to create a console URL. For more information, see Using IAM roles in the IAM User Guide. Defaults to None.
        permissions_boundary(str, optional): The ARN of the policy that is used to set the permissions boundary for the role. Defaults to None.
        tags(List, optional): A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated value. For more information about tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.init.create(
                ctx, role_name=value, assume_role_policy_document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.init.create role_name=value, assume_role_policy_document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="create_role",
        op_kwargs={
            "Path": path,
            "RoleName": role_name,
            "AssumeRolePolicyDocument": assume_role_policy_document,
            "Description": description,
            "MaxSessionDuration": max_session_duration,
            "PermissionsBoundary": permissions_boundary,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, role_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified role. The role must not have any policies attached. For more information about roles, see Working with roles.  Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a role or instance profile that is associated with a running instance will break any applications running on the instance.

    Args:
        role_name(str): The name of the role to delete. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.init.delete(ctx, role_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.init.delete role_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_role",
        op_kwargs={"RoleName": role_name},
    )


async def get(hub, ctx, role_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy that grants permission to assume the role. For more information about roles, see Working with roles.  Policies returned by this operation are URL-encoded compliant with RFC 3986. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the decode method of the java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs provide similar functionality.

    Args:
        role_name(str): The name of the IAM role to get information about. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.init.get(ctx, role_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.init.get role_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iam", operation="get_role", op_kwargs={"RoleName": role_name}
    )


async def list_all(
    hub, ctx, path_prefix: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list. For more information about roles, see Working with roles.  IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a role, see GetRole.  You can paginate the results using the MaxItems and Marker parameters.

    Args:
        path_prefix(str, optional):  The path prefix for filtering the results. For example, the prefix /application_abc/component_xyz/ gets all roles whose path starts with /application_abc/component_xyz/. This parameter is optional. If it is not included, it defaults to a slash (/), listing all roles. This parameter allows (through its regex pattern) a string of characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F), including most punctuation characters, digits, and upper and lowercased letters. Defaults to None.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_roles",
        op_kwargs={"PathPrefix": path_prefix, "Marker": marker, "MaxItems": max_items},
    )


async def tag(hub, ctx, role_name: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds one or more tags to an IAM role. The role can be a regular role or a service-linked role. If a tag with the same key name already exists, then that tag is overwritten with the new value. A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:    Administrative grouping and discovery - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name Project and the value MyImportantProject. Or search for all resources with the key name Cost Center and the value 41200.     Access control - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM role that has a specified tag attached. You can also restrict access to only those resources that have a certain tag attached. For examples of policies that show how to use tags to control access, see Control access using IAM tags in the IAM User Guide.    Cost allocation - Use tags to help track which individuals and teams are using which Amazon Web Services resources.      If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web Services always interprets the tag Value as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.    For more information about tagging, see Tagging IAM identities in the IAM User Guide.

    Args:
        role_name(str): The name of the IAM role to which you want to add tags. This parameter accepts (through its regex pattern) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tags(List): The list of tags that you want to attach to the IAM role. Each tag consists of a key name and an associated value.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.init.tag(ctx, role_name=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.init.tag role_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="tag_role",
        op_kwargs={"RoleName": role_name, "Tags": tags},
    )


async def untag(hub, ctx, role_name: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes the specified tags from the role. For more information about tagging, see Tagging IAM resources in the IAM User Guide.

    Args:
        role_name(str): The name of the IAM role from which you want to remove tags. This parameter accepts (through its regex pattern) a string of characters that consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tag_keys(List): A list of key names as a simple array of strings. The tags with matching keys are removed from the specified role.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.init.untag(ctx, role_name=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.init.untag role_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="untag_role",
        op_kwargs={"RoleName": role_name, "TagKeys": tag_keys},
    )


async def update(
    hub, ctx, role_name: str, description: str = None, max_session_duration: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the description or maximum session duration setting of a role.

    Args:
        role_name(str): The name of the role that you want to modify.
        description(str, optional): The new description that you want to apply to the specified role. Defaults to None.
        max_session_duration(int, optional): The maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours. Anyone who assumes the role from the CLI or API can use the DurationSeconds API parameter or the duration-seconds CLI parameter to request a longer session. The MaxSessionDuration setting determines the maximum duration that can be requested using the DurationSeconds parameter. If users don't specify a value for the DurationSeconds parameter, their security credentials are valid for one hour by default. This applies when you use the AssumeRole* API operations or the assume-role* CLI operations but does not apply when you use those operations to create a console URL. For more information, see Using IAM roles in the IAM User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.init.update(ctx, role_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.init.update role_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_role",
        op_kwargs={
            "RoleName": role_name,
            "Description": description,
            "MaxSessionDuration": max_session_duration,
        },
    )
