"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def remove(hub, ctx, instance_profile_name: str, role_name: str) -> None:
    r"""
    **Autogenerated function**

    Removes the specified IAM role from the specified EC2 instance profile.  Make sure that you do not have any Amazon EC2 instances running with the role you are about to remove from the instance profile. Removing a role from an instance profile that is associated with a running instance might break any applications running on the instance.   For more information about IAM roles, see Working with roles. For more information about instance profiles, see About instance profiles.

    Args:
        instance_profile_name(str): The name of the instance profile to update. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        role_name(str): The name of the role to remove. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.from_instance_profile.remove(
                ctx, instance_profile_name=value, role_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.from_instance_profile.remove instance_profile_name=value, role_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="remove_role_from_instance_profile",
        op_kwargs={"InstanceProfileName": instance_profile_name, "RoleName": role_name},
    )
