"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, role_name: str, description: str) -> Dict:
    r"""
    **Autogenerated function**

    Use UpdateRole instead. Modifies only the description of a role. This operation performs the same function as the Description parameter in the UpdateRole operation.

    Args:
        role_name(str): The name of the role that you want to modify.
        description(str): The new description that you want to apply to the specified role.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.role.description.update(
                ctx, role_name=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.role.description.update role_name=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_role_description",
        op_kwargs={"RoleName": role_name, "Description": description},
    )
