"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def change(hub, ctx, old_password: str, new_password: str) -> None:
    r"""
    **Autogenerated function**

    Changes the password of the IAM user who is calling this operation. This operation can be performed using the CLI, the Amazon Web Services API, or the My Security Credentials page in the Management Console. The account root user password is not affected by this operation. Use UpdateLoginProfile to use the CLI, the Amazon Web Services API, or the Users page in the IAM console to change the password for any IAM user. For more information about modifying passwords, see Managing passwords in the IAM User Guide.

    Args:
        old_password(str): The IAM user's current password.
        new_password(str): The new password. The new password must conform to the account's password policy, if one exists. The regex pattern that is used to validate this parameter is a string of characters. That string can include almost any printable ASCII character from the space (\u0020) through the end of the ASCII character range (\u00FF). You can also include the tab (\u0009), line feed (\u000A), and carriage return (\u000D) characters. Any of these characters are valid in a password. However, many tools, such as the Management Console, might restrict the ability to type certain characters because they have special meaning within that tool.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.password.change(ctx, old_password=value, new_password=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.password.change old_password=value, new_password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="change_password",
        op_kwargs={"OldPassword": old_password, "NewPassword": new_password},
    )
