"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def update(
    hub, ctx, open_id_connect_provider_arn: str, thumbprint_list: List
) -> None:
    r"""
    **Autogenerated function**

    Replaces the existing list of server certificate thumbprints associated with an OpenID Connect (OIDC) provider resource object with a new list of thumbprints. The list that you pass with this operation completely replaces the existing list of thumbprints. (The lists are not merged.) Typically, you need to update a thumbprint only when the identity provider certificate changes, which occurs rarely. However, if the provider's certificate does change, any attempt to assume an IAM role that specifies the OIDC provider as a principal fails until the certificate thumbprint is updated.  Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our library of trusted certificate authorities (CAs) instead of using a certificate thumbprint to verify your IdP server certificate. These OIDC IdPs include Google, and those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint. In these cases, your legacy thumbprint remains in your configuration, but is no longer used for validation.   Trust for the OIDC provider is derived from the provider certificate and is validated by the thumbprint. Therefore, it is best to limit access to the UpdateOpenIDConnectProviderThumbprint operation to highly privileged users.

    Args:
        open_id_connect_provider_arn(str): The Amazon Resource Name (ARN) of the IAM OIDC provider resource object for which you want to update the thumbprint. You can get a list of OIDC provider ARNs by using the ListOpenIDConnectProviders operation. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
        thumbprint_list(List): A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider. For more information, see CreateOpenIDConnectProvider. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.open_id_connect_provider.thumbprint.update(
                ctx, open_id_connect_provider_arn=value, thumbprint_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.open_id_connect_provider.thumbprint.update open_id_connect_provider_arn=value, thumbprint_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_open_id_connect_provider_thumbprint",
        op_kwargs={
            "OpenIDConnectProviderArn": open_id_connect_provider_arn,
            "ThumbprintList": thumbprint_list,
        },
    )
