"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    url: str,
    thumbprint_list: List,
    client_id_list: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an IAM entity to describe an identity provider (IdP) that supports OpenID Connect (OIDC). The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a policy establishes a trust relationship between Amazon Web Services and the OIDC provider. If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't need to create a separate IAM identity provider. These OIDC identity providers are already built-in to Amazon Web Services and are available for your use. Instead, you can move directly to creating new roles using your identity provider. To learn more, see Creating a role for web identity or OpenID connect federation in the IAM User Guide. When you create the IAM OIDC provider, you specify the following:   The URL of the OIDC identity provider (IdP) to trust   A list of client IDs (also known as audiences) that identify the application or applications allowed to authenticate using the OIDC provider   A list of thumbprints of one or more server certificates that the IdP uses   You get all of this information from the OIDC IdP that you want to use to access Amazon Web Services.  Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our library of trusted certificate authorities (CAs) instead of using a certificate thumbprint to verify your IdP server certificate. These OIDC IdPs include Google, and those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint. In these cases, your legacy thumbprint remains in your configuration, but is no longer used for validation.   The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is best to limit access to the CreateOpenIDConnectProvider operation to highly privileged users.

    Args:
        url(str): The URL of the identity provider. The URL must begin with https:// and should correspond to the iss claim in the provider's OpenID Connect ID tokens. Per the OIDC standard, path components are allowed but query parameters are not. Typically the URL consists of only a hostname, like https://server.example.org or https://example.com. You cannot register the same provider multiple times in a single account. If you try to submit a URL that has already been used for an OpenID Connect provider in the account, you will get an error.
        client_id_list(List, optional): A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the client_id parameter on OAuth requests.) You can register multiple client IDs with the same provider. For example, you might have multiple applications that use the same OIDC provider. You cannot register more than 100 client IDs with a single IAM OIDC provider. There is no defined format for a client ID. The CreateOpenIDConnectProviderRequest operation accepts client IDs up to 255 characters long. Defaults to None.
        thumbprint_list(List): A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificates. Typically this list includes only one entry. However, IAM lets you have up to five thumbprints for an OIDC provider. This lets you maintain multiple thumbprints if the identity provider is rotating certificates. The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509 certificate used by the domain where the OpenID Connect provider makes its keys available. It is always a 40-character string. You must provide at least one thumbprint when creating an IAM OIDC provider. For example, assume that the OIDC provider is server.example.com and the provider stores its keys at https://keys.server.example.com/openid-connect. In that case, the thumbprint string would be the hex-encoded SHA-1 hash value of the certificate used by https://keys.server.example.com. For more information about obtaining the OIDC provider's thumbprint, see Obtaining the thumbprint for an OpenID Connect provider in the IAM User Guide.
        tags(List, optional): A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider. Each tag consists of a key name and an associated value. For more information about tagging, see Tagging IAM resources in the IAM User Guide.  If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.open_id_connect_provider.init.create(
                ctx, url=value, thumbprint_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.open_id_connect_provider.init.create url=value, thumbprint_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="create_open_id_connect_provider",
        op_kwargs={
            "Url": url,
            "ClientIDList": client_id_list,
            "ThumbprintList": thumbprint_list,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, open_id_connect_provider_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an OpenID Connect identity provider (IdP) resource object in IAM. Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in their trust policies. Any attempt to assume a role that references a deleted provider fails. This operation is idempotent; it does not fail or return an error if you call the operation for a provider that does not exist.

    Args:
        open_id_connect_provider_arn(str): The Amazon Resource Name (ARN) of the IAM OpenID Connect provider resource object to delete. You can get a list of OpenID Connect provider resource ARNs by using the ListOpenIDConnectProviders operation.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.open_id_connect_provider.init.delete(
                ctx, open_id_connect_provider_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.open_id_connect_provider.init.delete open_id_connect_provider_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_open_id_connect_provider",
        op_kwargs={"OpenIDConnectProviderArn": open_id_connect_provider_arn},
    )


async def get(hub, ctx, open_id_connect_provider_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.

    Args:
        open_id_connect_provider_arn(str): The Amazon Resource Name (ARN) of the OIDC provider resource object in IAM to get information for. You can get a list of OIDC provider resource ARNs by using the ListOpenIDConnectProviders operation. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.open_id_connect_provider.init.get(
                ctx, open_id_connect_provider_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.open_id_connect_provider.init.get open_id_connect_provider_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="get_open_id_connect_provider",
        op_kwargs={"OpenIDConnectProviderArn": open_id_connect_provider_arn},
    )


async def list_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the account.  IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an OIDC provider, see GetOpenIDConnectProvider.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.open_id_connect_provider.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.open_id_connect_provider.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_open_id_connect_providers",
        op_kwargs={},
    )


async def tag(hub, ctx, open_id_connect_provider_arn: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For more information about these providers, see About web identity federation. If a tag with the same key name already exists, then that tag is overwritten with the new value. A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:    Administrative grouping and discovery - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name Project and the value MyImportantProject. Or search for all resources with the key name Cost Center and the value 41200.     Access control - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an OIDC provider that has a specified tag attached. For examples of policies that show how to use tags to control access, see Control access using IAM tags in the IAM User Guide.      If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web Services always interprets the tag Value as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.

    Args:
        open_id_connect_provider_arn(str): The ARN of the OIDC identity provider in IAM to which you want to add tags. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tags(List): The list of tags that you want to attach to the OIDC identity provider in IAM. Each tag consists of a key name and an associated value.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.open_id_connect_provider.init.tag(
                ctx, open_id_connect_provider_arn=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.open_id_connect_provider.init.tag open_id_connect_provider_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="tag_open_id_connect_provider",
        op_kwargs={
            "OpenIDConnectProviderArn": open_id_connect_provider_arn,
            "Tags": tags,
        },
    )


async def untag(hub, ctx, open_id_connect_provider_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity provider in IAM. For more information about OIDC providers, see About web identity federation. For more information about tagging, see Tagging IAM resources in the IAM User Guide.

    Args:
        open_id_connect_provider_arn(str): The ARN of the OIDC provider in IAM from which you want to remove tags. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tag_keys(List): A list of key names as a simple array of strings. The tags with matching keys are removed from the specified OIDC provider.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.open_id_connect_provider.init.untag(
                ctx, open_id_connect_provider_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.open_id_connect_provider.init.untag open_id_connect_provider_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="untag_open_id_connect_provider",
        op_kwargs={
            "OpenIDConnectProviderArn": open_id_connect_provider_arn,
            "TagKeys": tag_keys,
        },
    )
