"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deactivate(hub, ctx, user_name: str, serial_number: str) -> None:
    r"""
    **Autogenerated function**

    Deactivates the specified MFA device and removes it from association with the user name for which it was originally enabled. For more information about creating and working with virtual MFA devices, see Enabling a virtual multi-factor authentication (MFA) device in the IAM User Guide.

    Args:
        user_name(str): The name of the user whose MFA device you want to deactivate. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        serial_number(str): The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.mfa_device.init.deactivate(
                ctx, user_name=value, serial_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.mfa_device.init.deactivate user_name=value, serial_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="deactivate_mfa_device",
        op_kwargs={"UserName": user_name, "SerialNumber": serial_number},
    )


async def enable(
    hub,
    ctx,
    user_name: str,
    serial_number: str,
    authentication_code1: str,
    authentication_code2: str,
) -> None:
    r"""
    **Autogenerated function**

    Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is required for every subsequent login by the IAM user associated with the device.

    Args:
        user_name(str): The name of the IAM user for whom you want to enable the MFA device. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        serial_number(str): The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: =,.@:/-.
        authentication_code1(str): An authentication code emitted by the device.  The format for this parameter is a string of six digits.  Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can resync the device. .
        authentication_code2(str): A subsequent authentication code emitted by the device. The format for this parameter is a string of six digits.  Submit your request immediately after generating the authentication codes. If you generate the codes and then wait too long to submit the request, the MFA device successfully associates with the user but the MFA device becomes out of sync. This happens because time-based one-time passwords (TOTP) expire after a short period of time. If this happens, you can resync the device. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.mfa_device.init.enable(
                ctx,
                user_name=value,
                serial_number=value,
                authentication_code1=value,
                authentication_code2=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.mfa_device.init.enable user_name=value, serial_number=value, authentication_code1=value, authentication_code2=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="enable_mfa_device",
        op_kwargs={
            "UserName": user_name,
            "SerialNumber": serial_number,
            "AuthenticationCode1": authentication_code1,
            "AuthenticationCode2": authentication_code2,
        },
    )


async def list_all(
    hub, ctx, user_name: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request for this operation. You can paginate the results using the MaxItems and Marker parameters.

    Args:
        user_name(str, optional): The name of the user whose MFA devices you want to list. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.mfa_device.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.mfa_device.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_mfa_devices",
        op_kwargs={"UserName": user_name, "Marker": marker, "MaxItems": max_items},
    )


async def resync(
    hub,
    ctx,
    user_name: str,
    serial_number: str,
    authentication_code1: str,
    authentication_code2: str,
) -> None:
    r"""
    **Autogenerated function**

    Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services servers. For more information about creating and working with virtual MFA devices, see Using a virtual MFA device in the IAM User Guide.

    Args:
        user_name(str): The name of the user whose MFA device you want to resynchronize. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        serial_number(str): Serial number that uniquely identifies the MFA device. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        authentication_code1(str): An authentication code emitted by the device. The format for this parameter is a sequence of six digits.
        authentication_code2(str): A subsequent authentication code emitted by the device. The format for this parameter is a sequence of six digits.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.mfa_device.init.resync(
                ctx,
                user_name=value,
                serial_number=value,
                authentication_code1=value,
                authentication_code2=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.mfa_device.init.resync user_name=value, serial_number=value, authentication_code1=value, authentication_code2=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="resync_mfa_device",
        op_kwargs={
            "UserName": user_name,
            "SerialNumber": serial_number,
            "AuthenticationCode1": authentication_code1,
            "AuthenticationCode2": authentication_code2,
        },
    )


async def tag(hub, ctx, serial_number: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If a tag with the same key name already exists, then that tag is overwritten with the new value. A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the following:    Administrative grouping and discovery - Attach tags to resources to aid in organization and search. For example, you could search for all resources with the key name Project and the value MyImportantProject. Or search for all resources with the key name Cost Center and the value 41200.     Access control - Include tags in IAM user-based and resource-based policies. You can use tags to restrict access to only an IAM virtual MFA device that has a specified tag attached. For examples of policies that show how to use tags to control access, see Control access using IAM tags in the IAM User Guide.      If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created. For more information about tagging, see Tagging IAM resources in the IAM User Guide.   Amazon Web Services always interprets the tag Value as a single string. If you need to store an array, you can store comma-separated values in the string. However, you must interpret the value in your code.

    Args:
        serial_number(str): The unique identifier for the IAM virtual MFA device to which you want to add tags. For virtual MFA devices, the serial number is the same as the ARN. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tags(List): The list of tags that you want to attach to the IAM virtual MFA device. Each tag consists of a key name and an associated value.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.mfa_device.init.tag(ctx, serial_number=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.mfa_device.init.tag serial_number=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="tag_mfa_device",
        op_kwargs={"SerialNumber": serial_number, "Tags": tags},
    )


async def untag(hub, ctx, serial_number: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes the specified tags from the IAM virtual multi-factor authentication (MFA) device. For more information about tagging, see Tagging IAM resources in the IAM User Guide.

    Args:
        serial_number(str): The unique identifier for the IAM virtual MFA device from which you want to remove tags. For virtual MFA devices, the serial number is the same as the ARN. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        tag_keys(List): A list of key names as a simple array of strings. The tags with matching keys are removed from the specified instance profile.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.mfa_device.init.untag(
                ctx, serial_number=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.mfa_device.init.untag serial_number=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="untag_mfa_device",
        op_kwargs={"SerialNumber": serial_number, "TagKeys": tag_keys},
    )
