"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, user_name: str, password: str, password_reset_required: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a password for the specified IAM user. A password allows an IAM user to access Amazon Web Services services through the Management Console. You can use the CLI, the Amazon Web Services API, or the Users page in the IAM console to create a password for any IAM user. Use ChangePassword to update your own existing password in the My Security Credentials page in the Management Console. For more information about managing passwords, see Managing passwords in the IAM User Guide.

    Args:
        user_name(str): The name of the IAM user to create a password for. The user must already exist. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        password(str): The new password for the user. The regex pattern that is used to validate this parameter is a string of characters. That string can include almost any printable ASCII character from the space (\u0020) through the end of the ASCII character range (\u00FF). You can also include the tab (\u0009), line feed (\u000A), and carriage return (\u000D) characters. Any of these characters are valid in a password. However, many tools, such as the Management Console, might restrict the ability to type certain characters because they have special meaning within that tool.
        password_reset_required(bool, optional): Specifies whether the user is required to set a new password on next sign-in. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.login_profile.create(ctx, user_name=value, password=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.login_profile.create user_name=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="create_login_profile",
        op_kwargs={
            "UserName": user_name,
            "Password": password,
            "PasswordResetRequired": password_reset_required,
        },
    )


async def delete(hub, ctx, user_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the password for the specified IAM user, which terminates the user's ability to access Amazon Web Services services through the Management Console. You can use the CLI, the Amazon Web Services API, or the Users page in the IAM console to delete a password for any IAM user. You can use ChangePassword to update, but not delete, your own password in the My Security Credentials page in the Management Console.   Deleting a user's password does not prevent a user from accessing Amazon Web Services through the command line interface or the API. To prevent all user access, you must also either make any access keys inactive or delete them. For more information about making keys inactive or deleting them, see UpdateAccessKey and DeleteAccessKey.

    Args:
        user_name(str): The name of the user whose password you want to delete. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.login_profile.delete(ctx, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.login_profile.delete user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_login_profile",
        op_kwargs={"UserName": user_name},
    )


async def get(hub, ctx, user_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the user name for the specified IAM user. A login profile is created when you create a password for the user to access the Management Console. If the user does not exist or does not have a password, the operation returns a 404 (NoSuchEntity) error. If you create an IAM user with access to the console, the CreateDate reflects the date you created the initial password for the user. If you create an IAM user with programmatic access, and then later add a password for the user to access the Management Console, the CreateDate reflects the initial password creation date. A user with programmatic access does not have a login profile unless you create a password for the user to access the Management Console.

    Args:
        user_name(str): The name of the user whose login profile you want to retrieve. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.login_profile.get(ctx, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.login_profile.get user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="get_login_profile",
        op_kwargs={"UserName": user_name},
    )


async def update(
    hub, ctx, user_name: str, password: str = None, password_reset_required: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Changes the password for the specified IAM user. You can use the CLI, the Amazon Web Services API, or the Users page in the IAM console to change the password for any IAM user. Use ChangePassword to change your own password in the My Security Credentials page in the Management Console. For more information about modifying passwords, see Managing passwords in the IAM User Guide.

    Args:
        user_name(str): The name of the user whose password you want to update. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        password(str, optional): The new password for the specified IAM user. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)   However, the format can be further restricted by the account administrator by setting a password policy on the account. For more information, see UpdateAccountPasswordPolicy. Defaults to None.
        password_reset_required(bool, optional): Allows this new password to be used only once by requiring the specified IAM user to set a new password on next sign-in. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.login_profile.update(ctx, user_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.login_profile.update user_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_login_profile",
        op_kwargs={
            "UserName": user_name,
            "Password": password,
            "PasswordResetRequired": password_reset_required,
        },
    )
