"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def attach(hub, ctx, group_name: str, policy_arn: str) -> None:
    r"""
    **Autogenerated function**

    Attaches the specified managed policy to the specified IAM group. You use this operation to attach a managed policy to a group. To embed an inline policy in a group, use PutGroupPolicy. As a best practice, you can validate your IAM policies. To learn more, see Validating IAM policies in the IAM User Guide. For more information about policies, see Managed policies and inline policies in the IAM User Guide.

    Args:
        group_name(str): The name (friendly name, not ARN) of the group to attach the policy to. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_arn(str): The Amazon Resource Name (ARN) of the IAM policy you want to attach. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.group.policy.attach(ctx, group_name=value, policy_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.group.policy.attach group_name=value, policy_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="attach_group_policy",
        op_kwargs={"GroupName": group_name, "PolicyArn": policy_arn},
    )


async def delete(hub, ctx, group_name: str, policy_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified inline policy that is embedded in the specified IAM group. A group can also have managed policies attached to it. To detach a managed policy from a group, use DetachGroupPolicy. For more information about policies, refer to Managed policies and inline policies in the IAM User Guide.

    Args:
        group_name(str): The name (friendly name, not ARN) identifying the group that the policy is embedded in. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_name(str): The name identifying the policy document to delete. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.group.policy.delete(
                ctx, group_name=value, policy_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.group.policy.delete group_name=value, policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_group_policy",
        op_kwargs={"GroupName": group_name, "PolicyName": policy_name},
    )


async def detach(hub, ctx, group_name: str, policy_arn: str) -> None:
    r"""
    **Autogenerated function**

    Removes the specified managed policy from the specified IAM group. A group can also have inline policies embedded with it. To delete an inline policy, use DeleteGroupPolicy. For information about policies, see Managed policies and inline policies in the IAM User Guide.

    Args:
        group_name(str): The name (friendly name, not ARN) of the IAM group to detach the policy from. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_arn(str): The Amazon Resource Name (ARN) of the IAM policy you want to detach. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.group.policy.detach(ctx, group_name=value, policy_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.group.policy.detach group_name=value, policy_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="detach_group_policy",
        op_kwargs={"GroupName": group_name, "PolicyArn": policy_arn},
    )


async def get(hub, ctx, group_name: str, policy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified inline policy document that is embedded in the specified IAM group.  Policies returned by this operation are URL-encoded compliant with RFC 3986. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you use Java, you can use the decode method of the java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs provide similar functionality.  An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is attached to a group, use GetPolicy to determine the policy's default version, then use GetPolicyVersion to retrieve the policy document. For more information about policies, see Managed policies and inline policies in the IAM User Guide.

    Args:
        group_name(str): The name of the group the policy is associated with. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_name(str): The name of the policy document to get. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.group.policy.get(ctx, group_name=value, policy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.group.policy.get group_name=value, policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="get_group_policy",
        op_kwargs={"GroupName": group_name, "PolicyName": policy_name},
    )


async def list_all(
    hub, ctx, group_name: str, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the names of the inline policies that are embedded in the specified IAM group. An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a group, use ListAttachedGroupPolicies. For more information about policies, see Managed policies and inline policies in the IAM User Guide. You can paginate the results using the MaxItems and Marker parameters. If there are no inline policies embedded with the specified group, the operation returns an empty list.

    Args:
        group_name(str): The name of the group to list policies for. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.group.policy.list_all(ctx, group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.group.policy.list_all group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_group_policies",
        op_kwargs={"GroupName": group_name, "Marker": marker, "MaxItems": max_items},
    )


async def put(
    hub, ctx, group_name: str, policy_name: str, policy_document: str
) -> None:
    r"""
    **Autogenerated function**

    Adds or updates an inline policy document that is embedded in the specified IAM group. A user can also have managed policies attached to it. To attach a managed policy to a group, use AttachGroupPolicy. To create a new managed policy, use CreatePolicy. For information about policies, see Managed policies and inline policies in the IAM User Guide. For information about the maximum number of inline policies that you can embed in a group, see IAM and STS quotas in the IAM User Guide.  Because policy documents can be large, you should use POST rather than GET when calling PutGroupPolicy. For general information about using the Query API with IAM, see Making query requests in the IAM User Guide.

    Args:
        group_name(str): The name of the group to associate the policy with. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_name(str): The name of the policy document. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_document(str): The policy document. You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to = IAM. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.group.policy.put(
                ctx, group_name=value, policy_name=value, policy_document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.group.policy.put group_name=value, policy_name=value, policy_document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="put_group_policy",
        op_kwargs={
            "GroupName": group_name,
            "PolicyName": policy_name,
            "PolicyDocument": policy_document,
        },
    )
