"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, policy_arn: str, version_id: str) -> None:
    r"""
    **Autogenerated function**

    Sets the specified version of the specified policy as the policy's default (operative) version. This operation affects all users, groups, and roles that the policy is attached to. To list the users, groups, and roles that the policy is attached to, use ListEntitiesForPolicy. For information about managed policies, see Managed policies and inline policies in the IAM User Guide.

    Args:
        policy_arn(str): The Amazon Resource Name (ARN) of the IAM policy whose default version you want to set. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
        version_id(str): The version of the policy to set as the default (operative) version. For more information about managed policy versions, see Versioning for managed policies in the IAM User Guide.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.default_policy_version.set(
                ctx, policy_arn=value, version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.default_policy_version.set policy_arn=value, version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="set_default_policy_version",
        op_kwargs={"PolicyArn": policy_arn, "VersionId": version_id},
    )
