"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def generate(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

     Generates a credential report for the account. For more information about the credential report, see Getting credential reports in the IAM User Guide.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.credential_report.generate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.credential_report.generate
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iam", operation="generate_credential_report", op_kwargs={}
    )


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

     Retrieves a credential report for the account. For more information about the credential report, see Getting credential reports in the IAM User Guide.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.credential_report.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.credential_report.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iam", operation="get_credential_report", op_kwargs={}
    )
