"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def add(hub, ctx, open_id_connect_provider_arn: str, client_id: str) -> None:
    r"""
    **Autogenerated function**

    Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM OpenID Connect (OIDC) provider resource. This operation is idempotent; it does not fail or return an error if you add an existing client ID to the provider.

    Args:
        open_id_connect_provider_arn(str): The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to add the client ID to. You can get a list of OIDC provider ARNs by using the ListOpenIDConnectProviders operation.
        client_id(str): The client ID (also known as audience) to add to the IAM OpenID Connect provider resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.client_id_.to_open_id_connect_provider.add(
                ctx, open_id_connect_provider_arn=value, client_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.client_id_.to_open_id_connect_provider.add open_id_connect_provider_arn=value, client_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="add_client_id_to_open_id_connect_provider",
        op_kwargs={
            "OpenIDConnectProviderArn": open_id_connect_provider_arn,
            "ClientID": client_id,
        },
    )
