"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def remove(hub, ctx, open_id_connect_provider_arn: str, client_id: str) -> None:
    r"""
    **Autogenerated function**

    Removes the specified client ID (also known as audience) from the list of client IDs registered for the specified IAM OpenID Connect (OIDC) provider resource object. This operation is idempotent; it does not fail or return an error if you try to remove a client ID that does not exist.

    Args:
        open_id_connect_provider_arn(str): The Amazon Resource Name (ARN) of the IAM OIDC provider resource to remove the client ID from. You can get a list of OIDC provider ARNs by using the ListOpenIDConnectProviders operation. For more information about ARNs, see Amazon Resource Names (ARNs) in the Amazon Web Services General Reference.
        client_id(str): The client ID (also known as audience) to remove from the IAM OIDC provider resource. For more information about client IDs, see CreateOpenIDConnectProvider.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.client_id_.from_open_id_connect_provider.remove(
                ctx, open_id_connect_provider_arn=value, client_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.client_id_.from_open_id_connect_provider.remove open_id_connect_provider_arn=value, client_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="remove_client_id_from_open_id_connect_provider",
        op_kwargs={
            "OpenIDConnectProviderArn": open_id_connect_provider_arn,
            "ClientID": client_id,
        },
    )
