"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(hub, ctx, role_name: str, policy_document: str) -> None:
    r"""
    **Autogenerated function**

    Updates the policy that grants an IAM entity permission to assume a role. This is typically referred to as the "role trust policy". For more information about roles, see Using roles to delegate permissions and federate identities.

    Args:
        role_name(str): The name of the role to update with the new policy. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-.
        policy_document(str): The policy that grants an entity permission to assume the role. You must provide policies in JSON format in IAM. However, for CloudFormation templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM. The regex pattern used to validate this parameter is a string of characters consisting of the following:   Any printable ASCII character ranging from the space character (\u0020) through the end of the ASCII character range   The printable characters in the Basic Latin and Latin-1 Supplement character set (through \u00FF)   The special characters tab (\u0009), line feed (\u000A), and carriage return (\u000D)  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.assume_role_policy.update(
                ctx, role_name=value, policy_document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.assume_role_policy.update role_name=value, policy_document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_assume_role_policy",
        op_kwargs={"RoleName": role_name, "PolicyDocument": policy_document},
    )
