"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services account.  For information about IAM quotas, see IAM and STS quotas in the IAM User Guide.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.account.summary.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.account.summary.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iam", operation="get_account_summary", op_kwargs={}
    )
