"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Deletes the password policy for the account. There are no parameters.

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.account.password_policy.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.account.password_policy.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_account_password_policy",
        op_kwargs={},
    )


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the password policy for the account. This tells you the complexity requirements and mandatory rotation periods for the IAM user passwords in your account. For more information about using a password policy, see Managing an IAM password policy.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.account.password_policy.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.account.password_policy.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="iam", operation="get_account_password_policy", op_kwargs={}
    )


async def update(
    hub,
    ctx,
    minimum_password_length: int = None,
    require_symbols: bool = None,
    require_numbers: bool = None,
    require_uppercase_characters: bool = None,
    require_lowercase_characters: bool = None,
    allow_users_to_change_password: bool = None,
    max_password_age: int = None,
    password_reuse_prevention: int = None,
    hard_expiry: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the password policy settings for the account.    This operation does not support partial updates. No parameters are required, but if you do not specify a parameter, that parameter's value reverts to its default value. See the Request Parameters section for each parameter's default value. Also note that some parameters do not allow the default parameter to be explicitly set. Instead, to invoke the default value, do not include that parameter when you invoke the operation.     For more information about using a password policy, see Managing an IAM password policy in the IAM User Guide.

    Args:
        minimum_password_length(int, optional): The minimum number of characters allowed in an IAM user password. If you do not specify a value for this parameter, then the operation uses the default value of 6. Defaults to None.
        require_symbols(bool, optional): Specifies whether IAM user passwords must contain at least one of the following non-alphanumeric characters: ! @ # $ % ^ & * ( ) _ + - = [ ] { } | ' If you do not specify a value for this parameter, then the operation uses the default value of false. The result is that passwords do not require at least one symbol character. Defaults to None.
        require_numbers(bool, optional): Specifies whether IAM user passwords must contain at least one numeric character (0 to 9). If you do not specify a value for this parameter, then the operation uses the default value of false. The result is that passwords do not require at least one numeric character. Defaults to None.
        require_uppercase_characters(bool, optional): Specifies whether IAM user passwords must contain at least one uppercase character from the ISO basic Latin alphabet (A to Z). If you do not specify a value for this parameter, then the operation uses the default value of false. The result is that passwords do not require at least one uppercase character. Defaults to None.
        require_lowercase_characters(bool, optional): Specifies whether IAM user passwords must contain at least one lowercase character from the ISO basic Latin alphabet (a to z). If you do not specify a value for this parameter, then the operation uses the default value of false. The result is that passwords do not require at least one lowercase character. Defaults to None.
        allow_users_to_change_password(bool, optional):  Allows all IAM users in your account to use the Management Console to change their own passwords. For more information, see Letting IAM users change their own passwords in the IAM User Guide. If you do not specify a value for this parameter, then the operation uses the default value of false. The result is that IAM users in the account do not automatically have permissions to change their own password. Defaults to None.
        max_password_age(int, optional): The number of days that an IAM user password is valid. If you do not specify a value for this parameter, then the operation uses the default value of 0. The result is that IAM user passwords never expire. Defaults to None.
        password_reuse_prevention(int, optional): Specifies the number of previous passwords that IAM users are prevented from reusing. If you do not specify a value for this parameter, then the operation uses the default value of 0. The result is that IAM users are not prevented from reusing previous passwords. Defaults to None.
        hard_expiry(bool, optional): Prevents IAM users from setting a new password after their password has expired. The IAM user cannot be accessed until an administrator resets the password. If you do not specify a value for this parameter, then the operation uses the default value of false. The result is that IAM users can change their passwords after they expire and continue to sign in as the user. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.account.password_policy.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.account.password_policy.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_account_password_policy",
        op_kwargs={
            "MinimumPasswordLength": minimum_password_length,
            "RequireSymbols": require_symbols,
            "RequireNumbers": require_numbers,
            "RequireUppercaseCharacters": require_uppercase_characters,
            "RequireLowercaseCharacters": require_lowercase_characters,
            "AllowUsersToChangePassword": allow_users_to_change_password,
            "MaxPasswordAge": max_password_age,
            "PasswordReusePrevention": password_reuse_prevention,
            "HardExpiry": hard_expiry,
        },
    )
