"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def create(hub, ctx, account_alias: str) -> None:
    r"""
    **Autogenerated function**

    Creates an alias for your account. For information about using an account alias, see Using an alias for your account ID in the IAM User Guide.

    Args:
        account_alias(str): The account alias to create. This parameter allows (through its regex pattern) a string of characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have two dashes in a row.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.account.alias.create(ctx, account_alias=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.account.alias.create account_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="create_account_alias",
        op_kwargs={"AccountAlias": account_alias},
    )


async def delete(hub, ctx, account_alias: str) -> None:
    r"""
    **Autogenerated function**

     Deletes the specified account alias. For information about using an Amazon Web Services account alias, see Using an alias for your account ID in the IAM User Guide.

    Args:
        account_alias(str): The name of the account alias to delete. This parameter allows (through its regex pattern) a string of characters consisting of lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have two dashes in a row.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.account.alias.delete(ctx, account_alias=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.account.alias.delete account_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_account_alias",
        op_kwargs={"AccountAlias": account_alias},
    )
