"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, access_key_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about when the specified access key was last used. The information includes the date and time of last use, along with the Amazon Web Services service and Region that were specified in the last request made with that key.

    Args:
        access_key_id(str): The identifier of an access key. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.access_key.last_used.get(ctx, access_key_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.access_key.last_used.get access_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="get_access_key_last_used",
        op_kwargs={"AccessKeyId": access_key_id},
    )
