"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, user_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the specified user. The default status for new keys is Active. If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the account. Consequently, you can use this operation to manage account root user credentials. This is true even if the account has no associated users.  For information about quotas on the number of keys you can create, see IAM and STS quotas in the IAM User Guide.  To ensure the security of your account, the secret access key is accessible only during key and user creation. You must save the key (for example, in a text file) if you want to be able to access it again. If a secret key is lost, you can delete the access keys for the associated user and then create new keys.

    Args:
        user_name(str, optional): The name of the IAM user that the new key will belong to. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.access_key.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.access_key.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="create_access_key",
        op_kwargs={"UserName": user_name},
    )


async def delete(hub, ctx, access_key_id: str, user_name: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the access key pair associated with the specified IAM user. If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request. This operation works for access keys under the account. Consequently, you can use this operation to manage account root user credentials even if the account has no associated users.

    Args:
        user_name(str, optional): The name of the user whose access key pair you want to delete. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        access_key_id(str): The access key ID for the access key ID and secret access key you want to delete. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.access_key.init.delete(ctx, access_key_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.access_key.init.delete access_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="delete_access_key",
        op_kwargs={"UserName": user_name, "AccessKeyId": access_key_id},
    )


async def list_all(
    hub, ctx, user_name: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the access key IDs associated with the specified IAM user. If there is none, the operation returns an empty list. Although each user is limited to a small number of keys, you can still paginate the results using the MaxItems and Marker parameters. If the UserName field is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. This operation works for access keys under the account. Consequently, you can use this operation to manage account root user credentials even if the account has no associated users.  To ensure the security of your account, the secret access key is accessible only during key and user creation.

    Args:
        user_name(str, optional): The name of the user. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        marker(str, optional): Use this parameter only when paginating results and only after you receive a response indicating that the results are truncated. Set it to the value of the Marker element in the response that you received to indicate where the next call should start. Defaults to None.
        max_items(int, optional): Use this only when paginating results to indicate the maximum number of items you want in the response. If additional items exist beyond the maximum you specify, the IsTruncated response element is true. If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer results, even when there are more results available. In that case, the IsTruncated response element returns true, and Marker contains a value to include in the subsequent call that tells the service where to continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.access_key.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.access_key.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="list_access_keys",
        op_kwargs={"UserName": user_name, "Marker": marker, "MaxItems": max_items},
    )


async def update(
    hub, ctx, access_key_id: str, status: str, user_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Changes the status of the specified access key from Active to Inactive, or vice versa. This operation can be used to disable a user's key as part of a key rotation workflow. If the UserName is not specified, the user name is determined implicitly based on the Amazon Web Services access key ID used to sign the request. This operation works for access keys under the account. Consequently, you can use this operation to manage account root user credentials even if the account has no associated users. For information about rotating keys, see Managing keys and certificates in the IAM User Guide.

    Args:
        user_name(str, optional): The name of the user whose key you want to update. This parameter allows (through its regex pattern) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Defaults to None.
        access_key_id(str): The access key ID of the secret access key you want to update. This parameter allows (through its regex pattern) a string of characters that can consist of any upper or lowercased letter or digit.
        status(str):  The status you want to assign to the secret access key. Active means that the key can be used for programmatic calls to Amazon Web Services, while Inactive means that the key cannot be used.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.iam.access_key.init.update(
                ctx, access_key_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.iam.access_key.init.update access_key_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="iam",
        operation="update_access_key",
        op_kwargs={
            "UserName": user_name,
            "AccessKeyId": access_key_id,
            "Status": status,
        },
    )
